/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.HitResult;

public final class PlacementTarget {
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final BlockData data;

    public static PlacementTarget deserialize(CompoundTag nbt, boolean persisted) {
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("pos"));
        BlockData data = BlockData.deserialize(nbt.m_128469_("data"), persisted);
        return new PlacementTarget(pos, data);
    }

    public PlacementTarget(@Nonnull BlockPos pos, @Nonnull BlockData data) {
        this.pos = Objects.requireNonNull(pos);
        this.data = Objects.requireNonNull(data);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockData getData() {
        return this.data;
    }

    public boolean placeIn(BuildContext context) {
        return this.data.placeIn(context, this.pos);
    }

    public PlacementTarget mirror(Mirror mirror) {
        return new PlacementTarget(this.pos, this.data.mirror(mirror));
    }

    public PlacementTarget rotate(Rotation rotation) {
        return new PlacementTarget(this.getPos(), this.getData().rotate(rotation));
    }

    public MaterialList getRequiredMaterials(BuildContext context, @Nullable HitResult target) {
        return this.getData().getRequiredItems(context, target, this.getPos());
    }

    public CompoundTag serialize(boolean persisted) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("data", (Tag)this.data.serialize(persisted));
        compound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        return compound;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pos", (Object)this.pos).add("data", (Object)this.data).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlacementTarget)) {
            return false;
        }
        PlacementTarget that = (PlacementTarget)o;
        if (!this.getPos().equals((Object)that.getPos())) {
            return false;
        }
        return this.getData().equals(that.getData());
    }

    public int hashCode() {
        int result = this.getPos().hashCode();
        result = 31 * result + this.getData().hashCode();
        return result;
    }
}

