/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class GadgetUtils {
    private static final ImmutableList<Block> DISALLOWED_BLOCKS = ImmutableList.of((Object)Blocks.f_50257_, (Object)Blocks.f_50142_, (Object)Blocks.f_50258_, (Object)Blocks.f_50752_, (Object)Blocks.f_50085_);
    private static final ImmutableList<String> LINK_STARTS = ImmutableList.of((Object)"http", (Object)"www");

    public static boolean mightBeLink(String s) {
        return LINK_STARTS.stream().anyMatch(s::startsWith);
    }

    public static void addTooltipNameAndAuthor(ItemStack stack, @Nullable Level world, List<Component> tooltip) {
        if (world != null) {
            world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
                Template template = provider.getTemplateForKey((ITemplateKey)key);
                TemplateHeader header = template.getHeader();
                if (header.getName() != null && !header.getName().isEmpty()) {
                    tooltip.add((Component)TooltipTranslation.TEMPLATE_NAME.componentTranslation(header.getName()).m_6270_(Styles.AQUA));
                }
                if (header.getAuthor() != null && !header.getAuthor().isEmpty()) {
                    tooltip.add((Component)TooltipTranslation.TEMPLATE_AUTHOR.componentTranslation(header.getAuthor()).m_6270_(Styles.AQUA));
                }
            }));
        }
    }

    @Nullable
    public static ByteArrayOutputStream getPasteStream(@Nonnull CompoundTag compound, @Nullable String name) throws IOException {
        CompoundTag withText;
        CompoundTag compoundTag = withText = name != null && !name.isEmpty() ? compound.m_6426_() : compound;
        if (name != null && !name.isEmpty()) {
            withText.m_128359_("template_name", name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NbtIo.m_128947_((CompoundTag)withText, (OutputStream)baos);
        return baos.size() < 32567 ? baos : null;
    }

    public static void setAnchor(ItemStack stack) {
        GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
    }

    public static void setAnchor(ItemStack stack, List<BlockPos> coordinates) {
        CompoundTag tagCompound = stack.m_41784_();
        tagCompound.m_128365_("anchor_coords", (Tag)coordinates.stream().map(NbtUtils::m_129224_).collect(Collectors.toCollection(ListTag::new)));
        stack.m_41751_(tagCompound);
    }

    public static Optional<List<BlockPos>> getAnchor(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            return Optional.empty();
        }
        ListTag coordList = (ListTag)tagCompound.m_128423_("anchor_coords");
        if (coordList == null || coordList.size() == 0) {
            return Optional.empty();
        }
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        for (int i = 0; i < coordList.size(); ++i) {
            coordinates.add(NbtUtils.m_129239_((CompoundTag)coordList.m_128728_(i)));
        }
        return Optional.of(coordinates);
    }

    public static void setToolRange(ItemStack stack, int range) {
        CompoundTag tagCompound = stack.m_41784_();
        tagCompound.m_128405_("range", range);
    }

    public static int getToolRange(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        return Mth.m_14045_((int)tagCompound.m_128451_("range"), (int)1, (int)((Integer)Config.GADGETS.maxRange.get()));
    }

    public static BlockData rotateOrMirrorBlock(Player player, PacketRotateMirror.Operation operation, BlockData data) {
        if (operation == PacketRotateMirror.Operation.MIRROR) {
            return data.mirror(player.m_6350_().m_122434_() == Direction.Axis.X ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK);
        }
        return data.rotate(Rotation.CLOCKWISE_90);
    }

    public static void rotateOrMirrorToolBlock(ItemStack stack, Player player, PacketRotateMirror.Operation operation) {
        GadgetUtils.setToolBlock(stack, GadgetUtils.rotateOrMirrorBlock(player, operation, GadgetUtils.getToolBlock(stack)));
    }

    private static void setToolBlock(ItemStack stack, @Nullable BlockData data) {
        CompoundTag tagCompound = stack.m_41784_();
        if (data == null) {
            data = BlockData.AIR;
        }
        CompoundTag stateTag = data.serialize(true);
        tagCompound.m_128365_("state", (Tag)stateTag);
        stack.m_41751_(tagCompound);
    }

    @Nonnull
    public static BlockData getToolBlock(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        BlockData res = BlockData.tryDeserialize(tagCompound.m_128469_("state"), true);
        if (res == null) {
            GadgetUtils.setToolBlock(stack, BlockData.AIR);
            return BlockData.AIR;
        }
        return res;
    }

    public static void linkToInventory(ItemStack stack, Player player) {
        Level world = player.f_19853_;
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE);
        if (world.m_8055_(VectorHelper.getLookingAt(player, stack).m_82425_()) == Blocks.f_50016_.m_49966_()) {
            return;
        }
        InventoryLinker.Result result = InventoryLinker.linkInventory(player.f_19853_, stack, lookingAt);
        player.m_5661_((Component)result.getI18n().componentTranslation(new Object[0]), true);
    }

    public static InteractionResultHolder<Block> selectBlock(ItemStack stack, Player player) {
        Level world = player.f_19853_;
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE);
        if (world.m_46859_(lookingAt.m_82425_())) {
            return InteractionResultHolder.m_19100_((Object)Blocks.f_50016_);
        }
        BlockState state = world.m_8055_(lookingAt.m_82425_());
        if (!((AbstractGadget)stack.m_41720_()).isAllowedBlock(state) || state.m_60734_() instanceof EffectBlock) {
            return InteractionResultHolder.m_19100_((Object)state.m_60734_());
        }
        if (DISALLOWED_BLOCKS.contains((Object)state.m_60734_())) {
            return InteractionResultHolder.m_19100_((Object)state.m_60734_());
        }
        if (state.m_60800_((BlockGetter)world, lookingAt.m_82425_()) < 0.0f) {
            return InteractionResultHolder.m_19100_((Object)state.m_60734_());
        }
        Optional<BlockData> data = InventoryHelper.getSafeBlockData(player, lookingAt.m_82425_(), player.m_7655_());
        data.ifPresent(placeState -> {
            BlockState actualState = placeState.getState();
            GadgetUtils.setToolBlock(stack, new BlockData(actualState, placeState.getTileData()));
        });
        return InteractionResultHolder.m_19090_((Object)state.m_60734_());
    }

    public static InteractionResult setRemoteInventory(ItemStack stack, Player player, Level world, BlockPos pos, boolean setTool) {
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return InteractionResult.PASS;
        }
        if (setTool && te instanceof ConstructionBlockTileEntity) {
            GadgetUtils.setToolBlock(stack, ((ConstructionBlockTileEntity)te).getConstructionBlockData());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static boolean anchorBlocks(Player player, ItemStack stack) {
        Optional<List<BlockPos>> anchorCoords = GadgetUtils.getAnchor(stack);
        if (anchorCoords.isPresent()) {
            GadgetUtils.setAnchor(stack);
            player.m_5661_((Component)MessageTranslation.ANCHOR_REMOVED.componentTranslation(new Object[0]).m_6270_(Styles.AQUA), true);
            return true;
        }
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, stack);
        BlockPos startBlock = lookingAt.m_82425_();
        Direction sideHit = lookingAt.m_82434_();
        if (player.f_19853_.m_46859_(startBlock)) {
            return false;
        }
        BlockData blockData = GadgetUtils.getToolBlock(stack);
        AbstractMode.UseContext context = new AbstractMode.UseContext(player.f_19853_, player, blockData.getState(), startBlock, stack, sideHit, stack.m_41720_() instanceof GadgetBuilding && GadgetBuilding.shouldPlaceAtop(stack), stack.m_41720_() instanceof GadgetBuilding ? GadgetBuilding.getConnectedArea(stack) : GadgetExchanger.getConnectedArea(stack));
        List<BlockPos> coords = stack.m_41720_() instanceof GadgetBuilding ? GadgetBuilding.getToolMode(stack).getMode().getCollection(context, player) : GadgetExchanger.getToolMode(stack).getMode().getCollection(context, player);
        GadgetUtils.setAnchor(stack, coords);
        player.m_5661_((Component)MessageTranslation.ANCHOR_SET.componentTranslation(new Object[0]).m_6270_(Styles.AQUA), true);
        return true;
    }

    public static String withSuffix(int count) {
        if (count < 1000) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f%c", (double)count / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static void writePOSToNBT(ItemStack stack, @Nullable BlockPos pos, String tagName) {
        CompoundTag tagCompound = stack.m_41784_();
        if (pos == null) {
            if (tagCompound.m_128423_(tagName) != null) {
                tagCompound.m_128473_(tagName);
                stack.m_41751_(tagCompound);
            }
            return;
        }
        tagCompound.m_128365_(tagName, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        stack.m_41751_(tagCompound);
    }

    @Nullable
    public static BlockPos getPOSFromNBT(ItemStack stack, String tagName) {
        CompoundTag stackTag = stack.m_41784_();
        if (!stackTag.m_128441_(tagName)) {
            return null;
        }
        CompoundTag posTag = stack.m_41784_().m_128469_(tagName);
        if (posTag.m_128456_()) {
            return null;
        }
        return NbtUtils.m_129239_((CompoundTag)posTag);
    }

    @Nullable
    public static ResourceLocation getDIMFromNBT(ItemStack stack, String tagName) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            return null;
        }
        CompoundTag posTag = tagCompound.m_128469_(tagName);
        if (posTag.equals((Object)new CompoundTag())) {
            return null;
        }
        return new ResourceLocation(posTag.m_128461_("dim"));
    }

    public static void dropTileEntityInventory(Level world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null) {
            LazyOptional cap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            cap.ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                }
            });
        }
    }
}

