/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.world;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
public class MockDelegationWorld
implements LevelAccessor {
    private final LevelAccessor delegate;
    private Map<BlockPos, BlockInfo> posToBlock;

    public MockDelegationWorld(LevelAccessor delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.posToBlock = new HashMap<BlockPos, BlockInfo>();
    }

    public Set<Map.Entry<BlockPos, BlockInfo>> entrySet() {
        return Collections.unmodifiableSet(this.posToBlock.entrySet());
    }

    public LevelAccessor getDelegate() {
        return this.delegate;
    }

    public void m_5594_(@Nullable Player player, BlockPos pos, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
    }

    public void m_7106_(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void m_5898_(@Nullable Player p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
    }

    public void m_142346_(@Nullable Entity p_151549_, GameEvent p_151550_, BlockPos p_151551_) {
    }

    public List<Entity> m_6249_(@Nullable Entity entity, AABB axisAlignedBB, @Nullable Predicate<? super Entity> predicate) {
        return new ArrayList<Entity>();
    }

    public <T extends Entity> List<T> m_142425_(EntityTypeTest<Entity, T> p_151464_, AABB p_151465_, Predicate<? super T> p_151466_) {
        return null;
    }

    public <T extends Entity> List<T> m_6443_(Class<T> p_45979_, AABB p_45980_, Predicate<? super T> p_45981_) {
        return List.of();
    }

    public List<? extends Player> m_6907_() {
        return new ArrayList();
    }

    @Nullable
    public ChunkAccess m_6522_(int p_217353_1_, int p_217353_2_, ChunkStatus p_217353_3_, boolean p_217353_4_) {
        return this.m_6325_(p_217353_1_, p_217353_2_);
    }

    public BlockPos m_5452_(Heightmap.Types heightmapType, BlockPos pos) {
        return this.getDelegate().m_5452_(heightmapType, pos);
    }

    public RegistryAccess m_5962_() {
        return null;
    }

    public boolean m_7471_(BlockPos blockPos, boolean b) {
        return this.removeOverride(blockPos);
    }

    public boolean m_7433_(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return p_217375_2_.test(this.m_8055_(p_217375_1_));
    }

    public boolean m_142433_(BlockPos p_151584_, Predicate<FluidState> p_151585_) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_46941_() {
        return this.delegate.m_46941_();
    }

    public ChunkAccess m_6325_(int chunkX, int chunkZ) {
        return this.delegate.m_6325_(chunkX, chunkZ);
    }

    public long m_183596_() {
        return this.delegate.m_183596_();
    }

    public LevelTickAccess<Block> m_183326_() {
        return this.delegate.m_183326_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return this.delegate.m_183324_();
    }

    public LevelData m_6106_() {
        return this.delegate.m_6106_();
    }

    public DifficultyInstance m_6436_(BlockPos pos) {
        return this.delegate.m_6436_(pos);
    }

    @Nullable
    public MinecraftServer m_142572_() {
        return this.delegate.m_142572_();
    }

    public Difficulty m_46791_() {
        return this.delegate.m_46791_();
    }

    public ChunkSource m_7726_() {
        return this.delegate.m_7726_();
    }

    public Random m_5822_() {
        return this.delegate.m_5822_();
    }

    public boolean m_46859_(BlockPos pos) {
        return this.m_8055_(pos).m_60795_();
    }

    public Holder<Biome> m_204166_(BlockPos p_204167_) {
        return super.m_204166_(p_204167_);
    }

    public Holder<Biome> m_203675_(int p_204159_, int p_204160_, int p_204161_) {
        return this.delegate.m_203675_(p_204159_, p_204160_, p_204161_);
    }

    public int m_6924_(Heightmap.Types heightmapType, int x, int z) {
        return this.delegate.m_6924_(heightmapType, x, z);
    }

    public int m_7445_() {
        return this.delegate.m_7445_();
    }

    public BiomeManager m_7062_() {
        return null;
    }

    public WorldBorder m_6857_() {
        return this.delegate.m_6857_();
    }

    public boolean m_5450_(@Nullable Entity entityIn, VoxelShape shape) {
        return this.delegate.m_5450_(entityIn, shape);
    }

    public int m_46852_(BlockPos pos, Direction direction) {
        return this.delegate.m_46852_(pos, direction);
    }

    public boolean m_5776_() {
        return this.delegate.m_5776_();
    }

    public int m_5736_() {
        return this.delegate.m_5736_();
    }

    public DimensionType m_6042_() {
        return this.delegate.m_6042_();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        if (this.delegate.m_151570_(pos)) {
            return null;
        }
        BlockInfo info = this.getOverriddenBlock(pos);
        if (info != null) {
            return info.getEntity(this);
        }
        return this.delegate.m_7702_(pos);
    }

    public BlockState m_8055_(BlockPos pos) {
        if (this.delegate.m_151570_(pos)) {
            return Blocks.f_50626_.m_49966_();
        }
        BlockState state = this.getOverriddenState(pos);
        return state != null ? state : Blocks.f_50016_.m_49966_();
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public int m_7469_() {
        return this.delegate.m_7469_();
    }

    public boolean m_6933_(BlockPos p_241211_1_, BlockState p_241211_2_, int p_241211_3_, int p_241211_4_) {
        return false;
    }

    public boolean m_7731_(BlockPos pos, BlockState newState, int flags) {
        if (this.delegate.m_151570_(pos)) {
            return false;
        }
        BlockInfo info = this.getOverriddenBlock(pos);
        if (info != null) {
            info.setState(newState);
        } else {
            this.posToBlock.put(pos, this.createInfo(pos, newState));
        }
        return true;
    }

    public boolean m_46961_(BlockPos pos, boolean dropBlock) {
        return !this.m_8055_(pos).m_60795_() && this.m_7471_(pos, true);
    }

    public boolean m_7740_(BlockPos pos, boolean dropBlock, @Nullable Entity entity, int recursionLeft) {
        return false;
    }

    @Nullable
    public BlockInfo getOverriddenBlock(BlockPos pos) {
        return this.posToBlock.get(pos);
    }

    @Nullable
    public BlockState getOverriddenState(BlockPos pos) {
        BlockInfo info = this.getOverriddenBlock(pos);
        return info != null ? info.getState() : null;
    }

    @Nullable
    public BlockEntity getOverriddenTile(BlockPos pos) {
        BlockInfo info = this.getOverriddenBlock(pos);
        return info != null ? info.getEntity(this) : null;
    }

    public void clear() {
        this.posToBlock.clear();
    }

    public boolean removeOverride(BlockPos pos) {
        BlockInfo info = this.posToBlock.remove(pos);
        if (info != null) {
            info.onRemove();
            return true;
        }
        return false;
    }

    protected BlockInfo createInfo(BlockPos pos, BlockState state) {
        return new BlockInfo(pos, state);
    }

    public float m_46863_(BlockPos pos) {
        return this.delegate.m_46863_(pos);
    }

    public float m_7717_(Direction p_230487_1_, boolean p_230487_2_) {
        return 0.0f;
    }

    public LevelLightEngine m_5518_() {
        return this.delegate.m_5518_();
    }

    public static class BlockInfo {
        private BlockPos pos;
        private BlockState state;
        @Nullable
        private BlockEntity entity;

        public BlockInfo(BlockPos pos, BlockState state) {
            this.pos = Objects.requireNonNull(pos);
            this.state = Objects.requireNonNull(state);
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockInfo setPos(BlockPos pos) {
            this.pos = Objects.requireNonNull(pos);
            return this;
        }

        public BlockState getState() {
            return this.state;
        }

        public BlockInfo setState(BlockState state) {
            Preconditions.checkNotNull((Object)state);
            if (this.state.m_60734_() != state.m_60734_() || !state.m_155947_()) {
                this.onRemove();
            }
            this.state = state;
            return this;
        }

        @Nullable
        public BlockEntity getEntity(LevelAccessor world) {
            if (this.entity == null && this.state.m_155947_()) {
                try {
                    this.entity = ((EntityBlock)this.state.m_60734_()).m_142194_(this.pos, this.state);
                    if (this.entity != null) {
                        this.entity.onLoad();
                    }
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.debug("Tile Entity at {} with state {} threw exception whilst creating.", (Object)this.pos, (Object)this.state, (Object)e);
                }
            }
            return this.entity;
        }

        public void onRemove() {
            if (this.entity != null) {
                try {
                    this.entity.m_7651_();
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.debug("Tile Entity at {} with state {} threw exception whilst removing.", (Object)this.pos, (Object)this.state, (Object)e);
                }
                this.entity = null;
            }
        }
    }
}

