/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.client.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.config.ConfigManager;

public class BarrelModel
implements IModelGeometry<BarrelModel> {
    private final UnbakedModel opened;
    private final UnbakedModel unopened;
    private final UnbakedModel vanilla;
    private final UnbakedModel old_opened;
    private final UnbakedModel old_unopened;

    public BarrelModel(UnbakedModel opened, UnbakedModel unopened, UnbakedModel vanilla, UnbakedModel old_unopened, UnbakedModel old_opened) {
        this.opened = opened;
        this.unopened = unopened;
        this.vanilla = vanilla;
        this.old_opened = old_opened;
        this.old_unopened = old_unopened;
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet materials = Sets.newHashSet();
        materials.add(owner.resolveTexture("particle"));
        materials.addAll(this.unopened.m_5500_(modelGetter, missingTextureErrors));
        materials.addAll(this.opened.m_5500_(modelGetter, missingTextureErrors));
        materials.addAll(this.vanilla.m_5500_(modelGetter, missingTextureErrors));
        materials.addAll(this.old_opened.m_5500_(modelGetter, missingTextureErrors));
        materials.addAll(this.old_unopened.m_5500_(modelGetter, missingTextureErrors));
        return materials;
    }

    private static BakedModel buildModel(UnbakedModel entry, ModelState modelTransform, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation modelLocation) {
        return entry.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new BarrelBakedModel(owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), spriteGetter.apply(owner.resolveTexture("particle")), overrides, BarrelModel.buildModel(this.opened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.unopened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.vanilla, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.old_opened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.old_unopened, modelTransform, bakery, spriteGetter, modelLocation), (ImmutableMap<ItemTransforms.TransformType, Transformation>)PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(owner.getCombinedTransform(), modelTransform)));
    }

    private static final class BarrelBakedModel
    implements IDynamicBakedModel {
        private final boolean ambientOcclusion;
        private final boolean gui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final BakedModel opened;
        private final BakedModel unopened;
        private final BakedModel vanilla;
        private final BakedModel old_opened;
        private final BakedModel old_unopened;
        private final ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms;

        public BarrelBakedModel(boolean ambientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, BakedModel opened, BakedModel unopened, BakedModel vanilla, BakedModel old_opened, BakedModel old_unopened, ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms) {
            this.isSideLit = isSideLit;
            this.cameraTransforms = cameraTransforms;
            this.ambientOcclusion = ambientOcclusion;
            this.gui3d = isGui3d;
            this.particle = particle;
            this.overrides = overrides;
            this.opened = opened;
            this.unopened = unopened;
            this.vanilla = vanilla;
            this.old_opened = old_opened;
            this.old_unopened = old_unopened;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            BakedModel model = ConfigManager.isVanillaTextures() ? this.vanilla : (extraData.hasProperty(LootrBarrelBlock.OPENED) ? (extraData.getData(LootrBarrelBlock.OPENED) == Boolean.TRUE ? (ConfigManager.isOldTextures() ? this.old_opened : this.opened) : (ConfigManager.isOldTextures() ? this.old_unopened : this.unopened)) : (ConfigManager.isOldTextures() ? this.old_unopened : this.unopened));
            return model.getQuads(state, side, rand, extraData);
        }

        public boolean m_7541_() {
            return this.ambientOcclusion;
        }

        public boolean m_7539_() {
            return this.gui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
            if (ConfigManager.isVanillaTextures()) {
                return this.vanilla.m_6160_();
            }
            if (data.getData(LootrBarrelBlock.OPENED) == Boolean.TRUE) {
                return ConfigManager.isOldTextures() ? this.old_opened.m_6160_() : this.opened.m_6160_();
            }
            return ConfigManager.isOldTextures() ? this.old_unopened.m_6160_() : this.unopened.m_6160_();
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
            return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.cameraTransforms, (ItemTransforms.TransformType)cameraTransformType, (PoseStack)mat);
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public boolean isLayered() {
            return false;
        }
    }

    public static final class Loader
    implements IModelLoader<BarrelModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public BarrelModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            UnbakedModel unopened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"unopened"), BlockModel.class);
            UnbakedModel opened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"opened"), BlockModel.class);
            UnbakedModel vanilla = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"vanilla"), BlockModel.class);
            UnbakedModel old_unopened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"old_unopened"), BlockModel.class);
            UnbakedModel old_opened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"old_opened"), BlockModel.class);
            return new BarrelModel(opened, unopened, vanilla, old_unopened, old_opened);
        }
    }
}

