/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.Random;
import net.blay09.mods.cookingforblockheads.api.ToasterHandler;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.ToasterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ToasterBlock
extends BlockKitchen {
    public static final String name = "toaster";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "toaster");
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.4, (double)0.0, (double)4.4, (double)11.6, (double)6.4, (double)11.6);
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public ToasterBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60978_(2.5f), registryName);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ACTIVE});
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ToasterBlockEntity) {
            ToasterBlockEntity toaster = (ToasterBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (heldItem.m_41619_() || !toaster.getContainer().m_8020_(0).m_41619_() && !toaster.getContainer().m_8020_(1).m_41619_()) {
                if (!(toaster.isActive() || toaster.getContainer().m_8020_(0).m_41619_() && toaster.getContainer().m_8020_(1).m_41619_())) {
                    toaster.setActive(!toaster.isActive());
                }
            } else {
                ItemStack output;
                ToasterHandler toastHandler = CookingRegistry.getToasterHandler(heldItem);
                if (toastHandler != null && !(output = toastHandler.getToasterOutput(heldItem)).m_41619_()) {
                    for (int i = 0; i < toaster.getContainer().m_6643_(); ++i) {
                        if (!toaster.getContainer().m_8020_(i).m_41619_()) continue;
                        toaster.getContainer().m_6836_(i, player.m_150110_().f_35937_ ? heldItem.m_41777_().m_41620_(1) : heldItem.m_41620_(1));
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ToasterBlockEntity(pos, state);
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        ToasterBlockEntity tileEntity = (ToasterBlockEntity)world.m_7702_(pos);
        if (tileEntity != null && tileEntity.isActive()) {
            boolean burning = tileEntity.isBurningToast();
            float particleChance = tileEntity.getToastProgress();
            int particleCount = 1;
            if (burning) {
                particleChance *= 3.0f;
                particleCount = random.nextInt(1, Math.max(2, (int)Math.ceil(5.0f * tileEntity.getToastProgress())));
            }
            if (random.nextFloat() < particleChance) {
                for (int i = 0; i < particleCount; ++i) {
                    double x = (float)pos.m_123341_() + 0.5f + (random.nextFloat() - 0.5f) * 0.25f;
                    double y = (float)pos.m_123342_() + 0.2f + random.nextFloat() * 6.0f / 16.0f;
                    double z = (float)pos.m_123343_() + 0.5f + (random.nextFloat() - 0.5f) * 0.25f;
                    if (burning && Math.random() <= 0.5) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
                        continue;
                    }
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : ToasterBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.toaster.get()), ToasterBlockEntity::serverTick);
    }
}

