/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.compat.jei;

import com.tynoxs.buildersdelight.content.init.BdItems;
import com.tynoxs.buildersdelight.content.recipe.ChiselRecipe;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselRecipeCategory
implements IRecipeCategory<ChiselRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("buildersdelight", "chisel");
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final Component localizedName;

    public ChiselRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("buildersdelight:textures/gui/chisel_gui_jei.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 176, 85);
        this.localizedName = new TranslatableComponent("container.iron_chisel");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BdItems.IRON_CHISEL.get()));
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ChiselRecipe recipe, IFocusGroup focuses) {
        super.setRecipe(builder, (Object)recipe, focuses);
        builder.addSlot(RecipeIngredientRole.INPUT, 13, 8).addItemStacks(recipe.getVariants());
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (index >= recipe.getVariants().size()) continue;
                ItemStack stack = recipe.getVariants().get(index);
                builder.addSlot(RecipeIngredientRole.OUTPUT, 40 + j * 18, 8 + i * 18).addItemStacks(Arrays.asList(stack));
                ++index;
            }
        }
    }

    public Class<? extends ChiselRecipe> getRecipeClass() {
        return ChiselRecipe.class;
    }
}

