/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.content.block.custom;

import com.tynoxs.buildersdelight.content.block.custom.BlockLantern;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockCandle
extends BlockLantern {
    protected final ParticleOptions flameParticle;
    protected static final VoxelShape HANGING = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape STANDING = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    protected static final VoxelShape MOUNTED_NORTH = Block.m_49796_((double)4.0, (double)1.0, (double)6.0, (double)12.0, (double)15.0, (double)16.0);
    protected static final VoxelShape MOUNTED_SOUTH = Block.m_49796_((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)15.0, (double)10.0);
    protected static final VoxelShape MOUNTED_WEST = Block.m_49796_((double)6.0, (double)1.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0);
    protected static final VoxelShape MOUNTED_EAST = Block.m_49796_((double)0.0, (double)1.0, (double)4.0, (double)10.0, (double)15.0, (double)12.0);

    public BlockCandle(BlockBehaviour.Properties properties, ParticleOptions particle) {
        super(properties);
        this.flameParticle = particle;
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState blockState, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)blockState.m_61143_((Property)f_54117_);
        switch ((AttachFace)blockState.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                return STANDING;
            }
            case WALL: {
                return switch (direction) {
                    case Direction.EAST -> MOUNTED_EAST;
                    case Direction.WEST -> MOUNTED_WEST;
                    case Direction.SOUTH -> MOUNTED_SOUTH;
                    default -> MOUNTED_NORTH;
                };
            }
        }
        return HANGING;
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        Direction dir1 = (Direction)stateIn.m_61143_((Property)f_54117_);
        switch ((AttachFace)stateIn.m_61143_((Property)f_53179_)) {
            default: {
                double d0 = (double)pos.m_123341_() + 0.5;
                double d1 = (double)pos.m_123342_() + 1.01;
                double d2 = (double)pos.m_123343_() + 0.5;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
                break;
            }
            case WALL: {
                double xo1 = (double)(-dir1.m_122429_()) * 0.11;
                double zo2 = (double)(-dir1.m_122431_()) * 0.11;
                double d0 = (double)pos.m_123341_() + 0.5 + xo1;
                double d1 = (double)pos.m_123342_() + 0.92;
                double d2 = (double)pos.m_123343_() + 0.5 + zo2;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
                break;
            }
            case CEILING: {
                double d0 = (double)pos.m_123341_() + 0.5;
                double d1 = (double)pos.m_123342_() + 0.75;
                double d2 = (double)pos.m_123343_() + 0.15;
                double d3 = (double)pos.m_123341_() + 0.15;
                double d4 = (double)pos.m_123342_() + 0.75;
                double d5 = (double)pos.m_123343_() + 0.5;
                double d6 = (double)pos.m_123341_() + 0.85;
                double d7 = (double)pos.m_123342_() + 0.75;
                double d8 = (double)pos.m_123343_() + 0.5;
                double d9 = (double)pos.m_123341_() + 0.5;
                double d10 = (double)pos.m_123342_() + 0.75;
                double d11 = (double)pos.m_123343_() + 0.85;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d3, d4, d5, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d3, d4, d5, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d6, d7, d8, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d6, d7, d8, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d9, d10, d11, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d9, d10, d11, 0.0, 0.0, 0.0);
            }
        }
    }
}

