/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.cosmetics;

import java.util.Locale;
import net.valhelsia.valhelsia_core.client.cosmetics.Cosmetic;
import net.valhelsia.valhelsia_core.client.event.EntityRendererEvents;
import net.valhelsia.valhelsia_core.client.model.BeanieModel;
import net.valhelsia.valhelsia_core.client.model.CapModel;
import net.valhelsia.valhelsia_core.client.model.CauldronBackpackModel;
import net.valhelsia.valhelsia_core.client.model.CosmeticsModel;
import net.valhelsia.valhelsia_core.client.model.FlamingoFloatModel;
import net.valhelsia.valhelsia_core.client.model.PropellerCapModel;
import net.valhelsia.valhelsia_core.client.model.ScarfModel;
import net.valhelsia.valhelsia_core.client.model.ValhelsiaCapeModel;
import net.valhelsia.valhelsia_core.client.model.WitchHatModel;
import net.valhelsia.valhelsia_core.client.model.WitchsBroomModel;
import net.valhelsia.valhelsia_core.client.model.WitchsWandModel;

public enum CosmeticsModels {
    CAPE(new ValhelsiaCapeModel<T>(EntityRendererEvents.modelSet.m_171103_(ValhelsiaCapeModel.VALHELSIA_CAPE))),
    WITCH_HAT(new WitchHatModel<T>(EntityRendererEvents.modelSet.m_171103_(WitchHatModel.LAYER_LOCATION))),
    WITCHS_BROOM(new WitchsBroomModel<T>(EntityRendererEvents.modelSet.m_171103_(WitchsBroomModel.LAYER_LOCATION))),
    WITCHS_WAND(new WitchsWandModel<T>(EntityRendererEvents.modelSet.m_171103_(WitchsWandModel.LAYER_LOCATION))),
    CAULDRON_BACKPACK(new CauldronBackpackModel<T>(EntityRendererEvents.modelSet.m_171103_(CauldronBackpackModel.LAYER_LOCATION))),
    BEANIE(new BeanieModel<T>(EntityRendererEvents.modelSet.m_171103_(BeanieModel.LAYER_LOCATION))),
    SCARF(new ScarfModel<T>(EntityRendererEvents.modelSet.m_171103_(ScarfModel.LAYER_LOCATION))),
    PROPELLER_CAP(new PropellerCapModel<T>(EntityRendererEvents.modelSet.m_171103_(PropellerCapModel.LAYER_LOCATION), EntityRendererEvents.modelSet.m_171103_(PropellerCapModel.PROPELLER_LAYER_LOCATION))),
    CAP(new CapModel<T>(EntityRendererEvents.modelSet.m_171103_(CapModel.LAYER_LOCATION))),
    FLAMINGO_FLOAT(new FlamingoFloatModel<T>(EntityRendererEvents.modelSet.m_171103_(FlamingoFloatModel.LAYER_LOCATION)));

    private final CosmeticsModel<?> model;

    private CosmeticsModels(CosmeticsModel<?> model) {
        this.model = model;
    }

    public CosmeticsModel<?> getModel() {
        return this.model;
    }

    public static CosmeticsModel<?> getFromCosmetic(Cosmetic cosmetic) {
        String name = cosmetic.getName();
        if (name.contains("cape")) {
            return CAPE.getModel();
        }
        if (name.contains("witch_hat")) {
            return WITCH_HAT.getModel();
        }
        if (name.contains("witchs_wand")) {
            return WITCHS_WAND.getModel();
        }
        if (name.contains("beanie")) {
            return BEANIE.getModel();
        }
        if (name.contains("scarf")) {
            return SCARF.getModel();
        }
        if (name.contains("propeller_cap")) {
            return PROPELLER_CAP.getModel();
        }
        if (name.contains("cap")) {
            return CAP.getModel();
        }
        return CosmeticsModels.valueOf(name.toUpperCase(Locale.ROOT)).getModel();
    }
}

