/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.valhelsia.valhelsia_core.client.cosmetics.Cosmetic;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsModels;
import net.valhelsia.valhelsia_core.client.model.CosmeticsModel;
import net.valhelsia.valhelsia_core.client.model.PropellerCapModel;
import net.valhelsia.valhelsia_core.client.model.WitchHatModel;
import net.valhelsia.valhelsia_core.client.renderer.CosmeticsLayer;
import net.valhelsia.valhelsia_core.client.util.TextureDownloader;

public class CosmeticsHatLayer<T extends AbstractClientPlayer, M extends PlayerModel<T>>
extends RenderLayer<T, M>
implements CosmeticsLayer<T> {
    private final CosmeticsManager cosmeticsManager;
    private CosmeticsModel<T> model;
    private static int TICK_COUNT = 0;

    public CosmeticsHatLayer(RenderLayerParent<T, M> renderLayerParent, EntityModelSet modelSet) {
        super(renderLayerParent);
        this.model = new WitchHatModel(modelSet.m_171103_(WitchHatModel.LAYER_LOCATION));
        this.cosmeticsManager = CosmeticsManager.getInstance();
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        UUID uuid = player.m_142081_();
        List<Cosmetic> cosmetics = this.cosmeticsManager.getCosmeticsForPlayer(uuid, CosmeticsCategory.HAT);
        Cosmetic activeHat = this.cosmeticsManager.getActiveCosmeticForPlayer(uuid, CosmeticsCategory.HAT);
        if (activeHat == null || !cosmetics.contains(activeHat)) {
            return;
        }
        ResourceLocation texture = this.cosmeticsManager.getCosmeticTexture(activeHat);
        if (texture == null) {
            return;
        }
        this.model = CosmeticsModels.getFromCosmetic(activeHat);
        poseStack.m_85836_();
        if (this.model.translateToParent()) {
            ((PlayerModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
        }
        if (this.model != null) {
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)texture));
            this.model.getModel().m_6973_(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.setPosition(poseStack);
            this.model.getModel().m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            CosmeticsModel<T> cosmeticsModel = this.model;
            if (cosmeticsModel instanceof PropellerCapModel) {
                PropellerCapModel propellerCapModel = (PropellerCapModel)cosmeticsModel;
                ++TICK_COUNT;
                vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)TextureDownloader.getTexture("propeller_animation_" + ((AbstractClientPlayer)player).f_19853_.m_46467_() % 10L)));
                propellerCapModel.renderPropeller(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        poseStack.m_85849_();
    }

    @Override
    public void setModel(CosmeticsModel<T> model) {
        this.model = model;
    }
}

