/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class FramedBlockData
extends ModelDataMap {
    public static final ModelProperty<BlockAndTintGetter> LEVEL = new ModelProperty();
    public static final ModelProperty<BlockPos> POS = new ModelProperty();
    public static final ModelProperty<BlockState> CAMO = new ModelProperty();
    private final boolean ghostData;
    private final boolean[] hidden = new boolean[6];
    private WeakReference<BlockAndTintGetter> level = new WeakReference<Object>(null);
    private BlockPos pos = BlockPos.f_121853_;
    private BlockState camoState = Blocks.f_50016_.m_49966_();

    public FramedBlockData(boolean ghostData) {
        this.ghostData = ghostData;
    }

    public boolean hasProperty(ModelProperty<?> prop) {
        return prop == CAMO || super.hasProperty(prop);
    }

    public <T> T getData(ModelProperty<T> prop) {
        if (prop == CAMO) {
            return (T)this.camoState;
        }
        if (prop == LEVEL) {
            return this.level.get();
        }
        if (prop == POS) {
            return (T)this.pos;
        }
        return (T)super.getData(prop);
    }

    public <T> T setData(ModelProperty<T> prop, T data) {
        if (prop == CAMO) {
            this.camoState = (BlockState)data;
        } else if (prop == LEVEL) {
            this.level = new WeakReference<BlockAndTintGetter>((BlockAndTintGetter)data);
        } else if (prop == POS) {
            this.pos = (BlockPos)data;
        } else {
            return (T)super.setData(prop, data);
        }
        return data;
    }

    public boolean isGhostData() {
        return this.ghostData;
    }

    public void setCamoState(BlockState camoState) {
        this.camoState = camoState;
    }

    public void setSideHidden(Direction side, boolean hide) {
        this.hidden[side.ordinal()] = hide;
    }

    public BlockState getCamoState() {
        return this.camoState;
    }

    public boolean isSideHidden(Direction side) {
        return this.hidden[side.ordinal()];
    }
}

