/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;

public final class ClientConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ClientConfig INSTANCE;
    private static final String KEY_SHOW_GHOST_BLOCKS = "showGhostBlocks";
    private static final String KEY_FANCY_HITBOXES = "fancyHitboxes";
    private static final String KEY_DETAILED_CULLING = "detailedCulling";
    private static final String KEY_USE_DISCRETE_UV_STEPS = "discreteUVSteps";
    private static final String KEY_STATE_LOCK_MODE = "stateLockMode";
    private static final String KEY_TOGGLE_WATERLOG_MODE = "toggleWaterlogMode";
    private static final String KEY_TOGGLE_Y_SLOPE_MODE = "toggleYSlopeMode";
    private static final String KEY_REINFORCEMENT_MODE = "reinforcedMode";
    private static final String KEY_PRISM_OFFSET_MODE = "prismOffsetMode";
    private static final String KEY_SPLIT_LINES_MODE = "splitLineMode";
    private static final String KEY_ONE_WAY_WINDOW_MODE = "oneWayWindowMode";
    private static final String KEY_FRAME_BACKGROUND_MODE = "itemFrameBackgroundMode";
    public static final String TRANSLATION_SHOW_GHOST_BLOCKS;
    public static final String TRANSLATION_FANCY_HITBOXES;
    public static final String TRANSLATION_DETAILED_CULLING;
    public static final String TRANSLATION_USE_DISCRETE_UV_STEPS;
    public static final String TRANSLATION_STATE_LOCK_MODE;
    public static final String TRANSLATION_TOGGLE_WATERLOG_MODE;
    public static final String TRANSLATION_TOGGLE_Y_SLOPE_MODE;
    public static final String TRANSLATION_REINFORCEMENT_MODE;
    public static final String TRANSLATION_PRISM_OFFSET_MODE;
    public static final String TRANSLATION_SPLIT_LINES_MODE;
    public static final String TRANSLATION_ONE_WAY_WINDOW_MODE;
    public static final String TRANSLATION_FRAME_BACKGROUND_MODE;
    private static final String COMMENT_OVERLAY_HIDDEN = "If set to HIDDEN, the %s overlay will be completely hidden";
    private static final String COMMENT_OVERLAY_ICON = "If set to ICON, the %s overlay will only show an icon";
    private static final String COMMENT_OVERLAY_DETAILED = "If set to DETAILED, the %s overlay will show detailed info";
    public static boolean showGhostBlocks;
    public static boolean fancyHitboxes;
    public static boolean detailedCulling;
    public static boolean useDiscreteUVSteps;
    public static BlockInteractOverlay.Mode stateLockMode;
    public static BlockInteractOverlay.Mode toggleWaterlogMode;
    public static BlockInteractOverlay.Mode toggleYSlopeMode;
    public static BlockInteractOverlay.Mode reinforcementMode;
    public static BlockInteractOverlay.Mode prismOffsetMode;
    public static BlockInteractOverlay.Mode splitLineMode;
    public static BlockInteractOverlay.Mode oneWayWindowMode;
    public static BlockInteractOverlay.Mode frameBackgroundMode;
    private final ForgeConfigSpec.BooleanValue showGhostBlocksValue;
    private final ForgeConfigSpec.BooleanValue fancyHitboxesValue;
    private final ForgeConfigSpec.BooleanValue detailedCullingValue;
    private final ForgeConfigSpec.BooleanValue useDiscreteUVStepsValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> stateLockModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> toggleWaterlogModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> toggleYSlopeModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> reinforcementModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> prismOffsetModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> splitLineModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> oneWayWindowModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> frameBackgroundModeValue;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        builder.push("general");
        this.showGhostBlocksValue = builder.comment("Wether ghost blocks are shown when you are holding a framed block").translation(TRANSLATION_SHOW_GHOST_BLOCKS).define(KEY_SHOW_GHOST_BLOCKS, true);
        this.fancyHitboxesValue = builder.comment("Wether certain framed blocks should show fancy hitboxes").translation(TRANSLATION_FANCY_HITBOXES).define(KEY_FANCY_HITBOXES, true);
        this.detailedCullingValue = builder.comment("If false only full block faces of framed blocks will be culled, if true all outer faces of famed blocks can be culled").translation(TRANSLATION_DETAILED_CULLING).define(KEY_DETAILED_CULLING, true);
        this.useDiscreteUVStepsValue = builder.comment("If true, the UV remapping will use discrete steps to avoid floating point errors").translation(TRANSLATION_USE_DISCRETE_UV_STEPS).define(KEY_USE_DISCRETE_UV_STEPS, true);
        builder.pop();
        builder.push("overlay");
        this.stateLockModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("State Lock")).comment(COMMENT_OVERLAY_ICON.formatted("State Lock")).comment(COMMENT_OVERLAY_DETAILED.formatted("State Lock")).translation(TRANSLATION_STATE_LOCK_MODE).defineEnum(KEY_STATE_LOCK_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.toggleWaterlogModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Toggle Waterloggable")).comment(COMMENT_OVERLAY_ICON.formatted("Toggle Waterloggable")).comment(COMMENT_OVERLAY_DETAILED.formatted("Toggle Waterloggable")).translation(TRANSLATION_TOGGLE_WATERLOG_MODE).defineEnum(KEY_TOGGLE_WATERLOG_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.toggleYSlopeModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Toggle Slope Face")).comment(COMMENT_OVERLAY_ICON.formatted("Toggle Slope Face")).comment(COMMENT_OVERLAY_DETAILED.formatted("Toggle Slope Face")).translation(TRANSLATION_TOGGLE_Y_SLOPE_MODE).defineEnum(KEY_TOGGLE_Y_SLOPE_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.reinforcementModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Reinforcement")).comment(COMMENT_OVERLAY_ICON.formatted("Reinforcement")).comment(COMMENT_OVERLAY_DETAILED.formatted("Reinforcement")).translation(TRANSLATION_REINFORCEMENT_MODE).defineEnum(KEY_REINFORCEMENT_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.prismOffsetModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Prism Offset")).comment(COMMENT_OVERLAY_ICON.formatted("Prism Offset")).comment(COMMENT_OVERLAY_DETAILED.formatted("Prism Offset")).translation(TRANSLATION_PRISM_OFFSET_MODE).defineEnum(KEY_PRISM_OFFSET_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.splitLineModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Collapsible Block Split Line")).comment(COMMENT_OVERLAY_ICON.formatted("Collapsible Block Split Line")).comment(COMMENT_OVERLAY_DETAILED.formatted("Collapsible Block Split Line")).translation(TRANSLATION_SPLIT_LINES_MODE).defineEnum(KEY_SPLIT_LINES_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.oneWayWindowModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("One-Way Window")).comment(COMMENT_OVERLAY_ICON.formatted("One-Way Window")).comment(COMMENT_OVERLAY_DETAILED.formatted("One-Way Window")).translation(TRANSLATION_ONE_WAY_WINDOW_MODE).defineEnum(KEY_ONE_WAY_WINDOW_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.frameBackgroundModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Item Frame Background")).comment(COMMENT_OVERLAY_ICON.formatted("Item Frame Background")).comment(COMMENT_OVERLAY_DETAILED.formatted("Item Frame Background")).translation(TRANSLATION_FRAME_BACKGROUND_MODE).defineEnum(KEY_FRAME_BACKGROUND_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        builder.pop();
    }

    private static String translate(String key) {
        return Utils.translateConfig("client", key);
    }

    @SubscribeEvent
    public void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && event.getConfig().getModId().equals("framedblocks")) {
            showGhostBlocks = (Boolean)this.showGhostBlocksValue.get();
            fancyHitboxes = (Boolean)this.fancyHitboxesValue.get();
            detailedCulling = (Boolean)this.detailedCullingValue.get();
            useDiscreteUVSteps = (Boolean)this.useDiscreteUVStepsValue.get();
            stateLockMode = (BlockInteractOverlay.Mode)((Object)this.stateLockModeValue.get());
            toggleWaterlogMode = (BlockInteractOverlay.Mode)((Object)this.toggleWaterlogModeValue.get());
            toggleYSlopeMode = (BlockInteractOverlay.Mode)((Object)this.toggleYSlopeModeValue.get());
            reinforcementMode = (BlockInteractOverlay.Mode)((Object)this.reinforcementModeValue.get());
            prismOffsetMode = (BlockInteractOverlay.Mode)((Object)this.prismOffsetModeValue.get());
            splitLineMode = (BlockInteractOverlay.Mode)((Object)this.splitLineModeValue.get());
            oneWayWindowMode = (BlockInteractOverlay.Mode)((Object)this.oneWayWindowModeValue.get());
            frameBackgroundMode = (BlockInteractOverlay.Mode)((Object)this.frameBackgroundModeValue.get());
        }
    }

    static {
        TRANSLATION_SHOW_GHOST_BLOCKS = ClientConfig.translate(KEY_SHOW_GHOST_BLOCKS);
        TRANSLATION_FANCY_HITBOXES = ClientConfig.translate(KEY_FANCY_HITBOXES);
        TRANSLATION_DETAILED_CULLING = ClientConfig.translate(KEY_DETAILED_CULLING);
        TRANSLATION_USE_DISCRETE_UV_STEPS = ClientConfig.translate(KEY_USE_DISCRETE_UV_STEPS);
        TRANSLATION_STATE_LOCK_MODE = ClientConfig.translate(KEY_STATE_LOCK_MODE);
        TRANSLATION_TOGGLE_WATERLOG_MODE = ClientConfig.translate(KEY_TOGGLE_WATERLOG_MODE);
        TRANSLATION_TOGGLE_Y_SLOPE_MODE = ClientConfig.translate(KEY_TOGGLE_Y_SLOPE_MODE);
        TRANSLATION_REINFORCEMENT_MODE = ClientConfig.translate(KEY_REINFORCEMENT_MODE);
        TRANSLATION_PRISM_OFFSET_MODE = ClientConfig.translate(KEY_PRISM_OFFSET_MODE);
        TRANSLATION_SPLIT_LINES_MODE = ClientConfig.translate(KEY_SPLIT_LINES_MODE);
        TRANSLATION_ONE_WAY_WINDOW_MODE = ClientConfig.translate(KEY_ONE_WAY_WINDOW_MODE);
        TRANSLATION_FRAME_BACKGROUND_MODE = ClientConfig.translate(KEY_FRAME_BACKGROUND_MODE);
        showGhostBlocks = false;
        fancyHitboxes = false;
        detailedCulling = false;
        useDiscreteUVSteps = false;
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)configSpecPair.getRight();
        INSTANCE = (ClientConfig)configSpecPair.getLeft();
    }
}

