/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.interactive.FramedWaterloggablePressurePlateBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPressurePlateBlock
extends PressurePlateBlock
implements IFramedBlock {
    private static final Map<BlockType, BlockType> WATERLOGGING_SWITCH = Map.of(BlockType.FRAMED_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, BlockType.FRAMED_PRESSURE_PLATE, BlockType.FRAMED_STONE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, BlockType.FRAMED_STONE_PRESSURE_PLATE, BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE);
    private final BlockType type;

    protected FramedPressurePlateBlock(BlockType type, PressurePlateBlock.Sensitivity sensitivity, BlockBehaviour.Properties props) {
        super(sensitivity, props);
        this.type = type;
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        this.onStateChange(level, pos, oldState, newState);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_150930_((Item)FBContent.itemFramedHammer.get())) {
            if (!level.m_5776_()) {
                Utils.wrapInStateCopy((LevelAccessor)level, pos, player, ItemStack.f_41583_, false, false, () -> {
                    BlockState newState = FBContent.byType(WATERLOGGING_SWITCH.get(this.type)).m_49966_();
                    level.m_46597_(pos, newState);
                });
            }
            return true;
        }
        return false;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLight(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getCamoSound(state, level, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getCamoExplosionResistance(state, level, pos, explosion);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, level, pos, entity);
    }

    public MaterialColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
        return this.getCamoMapColor(level, pos, defaultColor);
    }

    public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return this.getCamoBeaconColorMultiplier(level, pos, beaconPos);
    }

    protected int m_6693_(Level level, BlockPos pos) {
        if (this.f_55250_ == null) {
            List players = level.m_45976_(Player.class, f_49287_.m_82338_(pos));
            if (!players.isEmpty()) {
                for (Player player : players) {
                    if (player.m_6090_()) continue;
                    return 15;
                }
            }
            return 0;
        }
        return super.m_6693_(level, pos);
    }

    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedBlockEntity(pos, state);
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    public static FramedPressurePlateBlock wood() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_PRESSURE_PLATE, PressurePlateBlock.Sensitivity.EVERYTHING, IFramedBlock.createProperties(BlockType.FRAMED_PRESSURE_PLATE).m_60910_().m_60978_(0.5f));
    }

    public static FramedPressurePlateBlock woodWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, PressurePlateBlock.Sensitivity.EVERYTHING, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE).m_60910_().m_60978_(0.5f));
    }

    public static FramedPressurePlateBlock stone() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_STONE_PRESSURE_PLATE, PressurePlateBlock.Sensitivity.MOBS, IFramedBlock.createProperties(BlockType.FRAMED_STONE_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f));
    }

    public static FramedPressurePlateBlock stoneWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, PressurePlateBlock.Sensitivity.MOBS, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f));
    }

    public static FramedPressurePlateBlock obsidian() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE, null, IFramedBlock.createProperties(BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f));
    }

    public static FramedPressurePlateBlock obsidianWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, null, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f));
    }
}

