/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.SizeValidators;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class MinimumSizeValidator
implements ISizeValidator {
    private final Vec3i minimumSize;

    @Override
    public Component isSizeValid(Vec3i size) {
        if (SizeValidators.compareVec3i(size, this.getMinimumSize()) >= 0) {
            return null;
        }
        return new TranslatableComponent("multiblock.cyclopscore.error.size.min", new Object[]{LocationHelpers.toCompactString(size.m_142082_(1, 1, 1)), LocationHelpers.toCompactString(this.getMinimumSize().m_142082_(1, 1, 1))});
    }

    public MinimumSizeValidator(Vec3i minimumSize) {
        this.minimumSize = minimumSize;
    }

    public Vec3i getMinimumSize() {
        return this.minimumSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinimumSizeValidator)) {
            return false;
        }
        MinimumSizeValidator other = (MinimumSizeValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vec3i this$minimumSize = this.getMinimumSize();
        Vec3i other$minimumSize = other.getMinimumSize();
        return !(this$minimumSize == null ? other$minimumSize != null : !this$minimumSize.equals(other$minimumSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinimumSizeValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vec3i $minimumSize = this.getMinimumSize();
        result = result * 59 + ($minimumSize == null ? 43 : $minimumSize.hashCode());
        return result;
    }

    public String toString() {
        return "MinimumSizeValidator(minimumSize=" + this.getMinimumSize() + ")";
    }
}

