/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class WorldHelpers {
    public static final int CHUNK_SIZE = 16;
    private static final double TICK_LAG_REDUCTION_MODULUS_MODIFIER = 1.0;

    public static boolean efficientTick(Level world, int baseModulus, int ... params) {
        int mod = (int)((double)baseModulus * 1.0);
        if (mod == 0) {
            mod = 1;
        }
        int offset = 0;
        for (int param : params) {
            offset += param;
        }
        return world.f_46441_.nextInt(mod) == Math.abs(offset) % mod;
    }

    public static boolean efficientTick(Level world, int baseModulus, BlockPos blockPos) {
        return WorldHelpers.efficientTick(world, baseModulus, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public static <T, W extends LevelAccessor> T foldArea(W world, int[] areaMin, int[] areaMax, BlockPos blockPos, WorldFoldingFunction<T, T, W> folder, T value) {
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        for (int xc = x - areaMin[0]; xc <= x + areaMax[0]; ++xc) {
            for (int yc = y - areaMin[1]; yc <= y + areaMax[1]; ++yc) {
                for (int zc = z - areaMin[2]; zc <= z + areaMax[2]; ++zc) {
                    value = folder.apply(value, world, new BlockPos(xc, yc, zc));
                }
            }
        }
        return value;
    }

    public static <T, W extends LevelAccessor> T foldArea(W world, int area, BlockPos blockPos, WorldFoldingFunction<T, T, W> folder, T value) {
        return WorldHelpers.foldArea(world, new int[]{area, area, area}, new int[]{area, area, area}, blockPos, folder, value);
    }

    public static interface WorldFoldingFunction<F, T, W> {
        @Nullable
        public T apply(@Nullable F var1, W var2, BlockPos var3);
    }
}

