/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APEntities;
import cofh.archersparadox.init.APItems;
import cofh.core.init.CoreMobEffects;
import cofh.lib.item.ArrowItemCoFH;
import cofh.lib.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EnderArrow
extends AbstractArrow {
    private static final float defaultDamage = 0.5f;
    private static final int DURATION = 80;
    private static final int DURATION_FACTOR = 2;
    public boolean discharged;
    private BlockPos origin;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new EnderArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new EnderArrow(world, posX, posY, posZ);
        }
    };

    public EnderArrow(EntityType<? extends EnderArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.f_36698_ = 0.5;
    }

    public EnderArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)APEntities.ENDER_ARROW.get(), shooter, worldIn);
        this.f_36698_ = 0.5;
        this.origin = shooter.m_142538_();
    }

    public EnderArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)APEntities.ENDER_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = 0.5;
        this.origin = new BlockPos(x, y, z);
    }

    protected ItemStack m_7941_() {
        return this.discharged ? new ItemStack((ItemLike)Items.f_42412_) : new ItemStack((ItemLike)APItems.ENDER_ARROW_ITEM.get());
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        super.m_6532_(raytraceResultIn);
        Entity shooter = this.m_37282_();
        if (raytraceResultIn.m_6662_() != HitResult.Type.MISS && !this.discharged && shooter != null) {
            int duration = 80;
            if (raytraceResultIn.m_6662_() == HitResult.Type.BLOCK) {
                Utils.teleportEntityTo((Entity)shooter, (BlockPos)this.m_142538_());
                if (shooter instanceof LivingEntity && !Utils.isFakePlayer((Entity)shooter)) {
                    ((LivingEntity)shooter).m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.ENDERFERENCE.get(), duration, 0, false, false));
                }
            }
            if (raytraceResultIn.m_6662_() == HitResult.Type.ENTITY) {
                Entity entity;
                BlockPos originPos = this.origin == null ? shooter.m_142538_() : this.origin;
                Utils.teleportEntityTo((Entity)shooter, (BlockPos)this.m_142538_());
                if (shooter instanceof LivingEntity && !Utils.isFakePlayer((Entity)shooter)) {
                    ((LivingEntity)shooter).m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.ENDERFERENCE.get(), duration, 0, false, false));
                }
                if ((entity = ((EntityHitResult)raytraceResultIn).m_82443_()) instanceof LivingEntity && entity.m_6072_()) {
                    Utils.teleportEntityTo((Entity)entity, (BlockPos)originPos);
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.ENDERFERENCE.get(), duration, 0, false, false));
                }
            }
            this.discharged = true;
        }
    }

    public void m_20254_(int seconds) {
    }

    public void m_36762_(boolean critical) {
    }

    public void m_36735_(int knockbackStrengthIn) {
    }

    public void m_36767_(byte level) {
    }

    public void m_8119_() {
        super.m_8119_();
        if ((!this.f_36703_ || this.m_36797_()) && Utils.isClientWorld((Level)this.f_19853_)) {
            Vec3 vec3d = this.m_20184_();
            double d1 = vec3d.f_82479_;
            double d2 = vec3d.f_82480_;
            double d0 = vec3d.f_82481_;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + d1 * 0.25, this.m_20186_() + d2 * 0.25, this.m_20189_() + d0 * 0.25, -d1, -d2 + 0.2, -d0);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("ArrowData", this.discharged);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.discharged = compound.m_128471_("ArrowData");
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

