/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vaultcommandblacklist.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class VaultCommandBlacklistConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> vaultCommandBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> commandBlockMessageList;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> restartWarningTimeSpans;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Vault Command Blacklist Config");
            this.vaultCommandBlacklist = builder.comment("Commands that can't be used in a vault. This will block the root command (i.e. if warp is blocked then /warp shops would be as well)").defineList("vaultCommandBlackList", Arrays.asList("spawn", "home", "sethome"), entry -> true);
            this.commandBlockMessageList = builder.comment("Messages sent to a player when a command has been canceled.").defineList("commandBlockMessageList", Arrays.asList("The Power of The Vault compels you... not to do that.", "You cannot use that in The Vault", "The energies of The Vault cancel your command."), entry -> true);
            this.restartWarningTimeSpans = builder.comment("A list of time ranges where a special warning will be given to player's about a restart. Define each time span as <before>;<after> with the time format of e.g 10:00:00 for 10AM.").defineList("restartWarningTimeSpans", Arrays.asList("23:30:00;23:59:59", "07:30:00;08:00:00", "15:30:00;16:00:00"), entry -> true);
            builder.pop();
        }
    }
}

