/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vaultcommandblacklist.events;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xyz.iwolfking.vaultcommandblacklist.VaultCommandBlacklist;
import xyz.iwolfking.vaultcommandblacklist.util.MessageFunctions;
import xyz.iwolfking.vaultcommandblacklist.util.TemporarySetCrystalAllowance;

public class VaultCrystalInteractEvent {
    public static Map<Object, Boolean> allowCrystalInteractMap = new HashMap<Object, Boolean>();

    public static void onRightClickWithVaultCrystalEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack interactItem = event.getItemStack();
        if (!interactItem.equals(ModItems.VAULT_CRYSTAL)) {
            return;
        }
        LocalTime target = LocalTime.parse(LocalTime.now().toString());
        Player player = event.getPlayer();
        if (allowCrystalInteractMap.get(player) != null && allowCrystalInteractMap.get(player).booleanValue()) {
            return;
        }
        if (ModItems.VAULT_CRYSTAL.equals(interactItem.m_41720_())) {
            Block interactBlock = event.getWorld().m_8055_(event.getPos()).m_60734_();
            for (Block frameBlock : ModConfigs.VAULT_PORTAL.getValidFrameBlocks()) {
                if (!interactBlock.equals(frameBlock)) continue;
                List<? extends String> timespans = VaultCommandBlacklist.RESTART_TIMESPANS;
                for (String string : timespans) {
                    String[] timespanSet = string.split(";");
                    LocalTime beforeTime = LocalTime.parse(timespanSet[1]);
                    LocalTime afterTime = LocalTime.parse(timespanSet[0]);
                    if (!target.isAfter(afterTime) || !target.isBefore(beforeTime)) continue;
                    long diff = target.until(beforeTime, ChronoUnit.MINUTES);
                    MessageFunctions.sendMessage(event.getPlayer(), (MutableComponent)new TextComponent(ChatFormatting.RED + "Are you sure you want to run a vault? The server will restart in " + diff + " minutes! Vaulting is not recommended."));
                    MessageFunctions.sendMessage(event.getPlayer(), (MutableComponent)new TextComponent(ChatFormatting.YELLOW + "If you would like to enter a vault anyway, you may right-click the portal again within the next 10 seconds."));
                    try {
                        TemporarySetCrystalAllowance.setAllowance((ServerPlayer)event.getPlayer());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }
}

