/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vaultcommandblacklist.util;

import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class MessageFunctions {
    public static void sendMessage(CommandSourceStack source, MutableComponent message) {
        MessageFunctions.sendMessage(source, message, false);
    }

    public static void sendMessage(Player player, MutableComponent message) {
        MessageFunctions.sendMessage(player, message, false);
    }

    public static void sendMessage(CommandSourceStack source, String m, ChatFormatting colour) {
        MessageFunctions.sendMessage(source, m, colour, false);
    }

    public static void sendMessage(Player player, String m, ChatFormatting colour) {
        MessageFunctions.sendMessage(player, m, colour, false);
    }

    public static void sendMessage(CommandSourceStack source, String m, ChatFormatting colour, boolean emptyline) {
        MessageFunctions.sendMessage(source, m, colour, emptyline, "");
    }

    public static void sendMessage(Player player, String m, ChatFormatting colour, boolean emptyline) {
        MessageFunctions.sendMessage(player, m, colour, emptyline, "");
    }

    public static void sendMessage(CommandSourceStack source, String m, ChatFormatting colour, String url) {
        MessageFunctions.sendMessage(source, m, colour, false, url);
    }

    public static void sendMessage(Player player, String m, ChatFormatting colour, String url) {
        MessageFunctions.sendMessage(player, m, colour, false, url);
    }

    public static void sendMessage(CommandSourceStack source, String m, ChatFormatting colour, boolean emptyline, String url) {
        if (m.isEmpty()) {
            return;
        }
        TextComponent message = new TextComponent(m);
        message.m_130940_(colour);
        if (m.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : m.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                Style clickstyle = message.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                message.m_130948_(clickstyle);
            }
        }
        MessageFunctions.sendMessage(source, (MutableComponent)message, emptyline);
    }

    public static void sendMessage(CommandSourceStack source, MutableComponent message, boolean emptyline) {
        if (emptyline) {
            source.m_81354_((Component)new TextComponent(""), false);
        }
        source.m_81354_((Component)message, false);
    }

    public static void sendMessage(Player player, String m, ChatFormatting colour, boolean emptyline, String url) {
        if (m.isEmpty()) {
            return;
        }
        TextComponent message = new TextComponent(m);
        message.m_130940_(colour);
        if (m.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : m.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                Style clickstyle = message.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                message.m_130948_(clickstyle);
            }
        }
        MessageFunctions.sendMessage(player, (MutableComponent)message, emptyline);
    }

    public static void sendMessage(Player player, MutableComponent message, boolean emptyline) {
        if (emptyline) {
            player.m_6352_((Component)new TextComponent(""), player.m_142081_());
        }
        player.m_6352_((Component)message, player.m_142081_());
    }

    public static void broadcastMessage(Level world, String m, ChatFormatting colour) {
        if (m.isEmpty()) {
            return;
        }
        TextComponent message = new TextComponent(m);
        message.m_130940_(colour);
        MessageFunctions.broadcastMessage(world, (MutableComponent)message);
    }

    public static void broadcastMessage(Level world, MutableComponent message) {
        MinecraftServer server = world.m_142572_();
        if (server == null) {
            return;
        }
        for (Player player : server.m_6846_().m_11314_()) {
            MessageFunctions.sendMessage(player, message);
        }
    }

    public static void sendMessageToPlayersAround(Level world, BlockPos p, int radius, String message, ChatFormatting colour) {
        if (message.isEmpty()) {
            return;
        }
        for (Entity around : world.m_45933_(null, new AABB((double)(p.m_123341_() - radius), (double)(p.m_123342_() - radius), (double)(p.m_123343_() - radius), (double)(p.m_123341_() + radius), (double)(p.m_123342_() + radius), (double)(p.m_123343_() + radius)))) {
            if (!(around instanceof Player)) continue;
            MessageFunctions.sendMessage((Player)around, message, colour);
        }
    }

    public static void sendMessageToPlayersAround(Level world, BlockPos p, int radius, MutableComponent message) {
        for (Entity around : world.m_45933_(null, new AABB((double)(p.m_123341_() - radius), (double)(p.m_123342_() - radius), (double)(p.m_123343_() - radius), (double)(p.m_123341_() + radius), (double)(p.m_123342_() + radius), (double)(p.m_123343_() + radius)))) {
            if (!(around instanceof Player)) continue;
            MessageFunctions.sendMessage((Player)around, message);
        }
    }
}

