/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.scalingbingoseals.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ScalingBingoSealsConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> useBingoSeal;
        public final ForgeConfigSpec.ConfigValue<Boolean> useArchitectSeal;
        public final ForgeConfigSpec.ConfigValue<Integer> defaultHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> defaultWidth;
        public final ForgeConfigSpec.ConfigValue<Integer> sealAddCount;
        public final ForgeConfigSpec.ConfigValue<Integer> maxSeals;
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldChangeCrystalName;
        public final ForgeConfigSpec.ConfigValue<Integer> sizeToSetInfiniteLayout;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Seal Replacement");
            this.useBingoSeal = builder.comment("Whether Bingo Seal should be replacing with Scaling Bingo objective.").define("useBingoSeal", true);
            this.useArchitectSeal = builder.comment("Whether Architect Seal should be replaced with Scaling Bingo Objective.").define("useArchitectSeal", false);
            builder.pop();
            builder.push("Scaling Bingo Config");
            this.defaultHeight = builder.comment("Default height of Bingo vault with a single Seal applied (default: 3)").define("defaultHeight", (Object)3);
            this.defaultWidth = builder.comment("Default width of Bingo vault with a single Seal applied (default: 3)").define("defaultWidth", (Object)3);
            this.sealAddCount = builder.comment("How much width and height each seal adds (default: 1)").define("sealAddCount", (Object)1);
            this.maxSeals = builder.comment("Maximum number of seals that can be applied (default: 7)").define("maxSeals", (Object)7);
            this.sizeToSetInfiniteLayout = builder.comment("If this is not 0, the size that the vault layout will start to be set to infinite. (default: 0)").define("sizeToSetInfiniteLayout", (Object)0);
            builder.pop();
            builder.push("Server Settings");
            this.shouldChangeCrystalName = builder.comment("Whether when adding a seal in anvil should change crystal name based on Bingo board size (useful for server-side only usage, default: false)").define("shouldChangeCrystalName", false);
            builder.pop();
        }
    }
}

