/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.scalingbingoseals.objective;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.objective.AwardCrateObjective;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.BingoObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.GridGatewayObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.VictoryObjective;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.task.BingoTask;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import xyz.iwolfking.scalingbingoseals.config.ScalingBingoSealsConfig;
import xyz.iwolfking.scalingbingoseals.mixin.accessors.BingoTaskConfigAccessor;

public class ScalingBingoCrystalObjective
extends CrystalObjective {
    private float objectiveProbability;
    private int sealCount;
    public static int DEFAULT_WIDTH = 3;
    public static int DEFAULT_HEIGHT = 3;

    public ScalingBingoCrystalObjective(float objectiveProbability, int sealCount) {
        this.objectiveProbability = objectiveProbability;
        this.sealCount = sealCount;
    }

    public ScalingBingoCrystalObjective() {
        this.sealCount = 1;
    }

    public Optional<Integer> getColor(float v) {
        return Optional.of(4821183);
    }

    public void configure(Vault vault, RandomSource random) {
        int level = ((VaultLevel)vault.get(Vault.LEVEL)).get();
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            ModConfigs.BINGO.generate(VaultMod.id((String)"default"), level).ifPresent(task -> {
                ((BingoTaskConfigAccessor)task.getConfig()).setWidth(this.getWidth());
                ((BingoTaskConfigAccessor)task.getConfig()).setHeight(this.getHeight());
                objectives.add(BingoObjective.of((BingoTask)task).add(GridGatewayObjective.of((float)this.objectiveProbability).add((Objective)AwardCrateObjective.ofConfig((VaultCrateBlock.Type)VaultCrateBlock.Type.BINGO, (String)"bingo", (int)level, (boolean)true)).add((Objective)VictoryObjective.of((int)300))));
            });
            objectives.add((Objective)BailObjective.create((boolean)true, (ResourceLocation[])new ResourceLocation[]{ClassicPortalLogic.EXIT}));
            objectives.add((Objective)DeathObjective.create((boolean)true));
            objectives.set(Objectives.KEY, (Object)CrystalData.OBJECTIVE.getType((ISerializable)this));
        });
    }

    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)new TextComponent(this.getHeight() + "x" + this.getWidth() + " Bingo").m_130948_(Style.f_131099_.m_178520_(this.getColor(time).orElseThrow().intValue()))));
    }

    public int getHeight() {
        return DEFAULT_HEIGHT + this.sealCount - 1;
    }

    public int getWidth() {
        return DEFAULT_WIDTH + this.sealCount - 1;
    }

    public int getSealCount() {
        return Math.min(this.sealCount, (Integer)ScalingBingoSealsConfig.COMMON.maxSeals.get());
    }

    public float getObjectiveProbability() {
        return this.objectiveProbability;
    }

    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.objectiveProbability)).ifPresent(tag -> nbt.m_128365_("objective_probability", tag));
        Adapters.INT.writeNbt((Number)this.sealCount).ifPresent(tag -> nbt.m_128365_("sealCount", tag));
        return Optional.of(nbt);
    }

    public void readNbt(CompoundTag nbt) {
        this.objectiveProbability = Adapters.FLOAT.readNbt(nbt.m_128423_("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
        this.sealCount = Adapters.INT.readNbt(nbt.m_128423_("sealCount")).orElse(1);
    }

    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.FLOAT.writeJson((Number)Float.valueOf(this.objectiveProbability)).ifPresent(tag -> json.add("objective_probability", tag));
        Adapters.INT.writeJson((Number)this.sealCount).ifPresent(tag -> json.add("sealCount", tag));
        return Optional.of(json);
    }

    public String getCrystalName() {
        return this.getHeight() + "x" + this.getWidth() + " Bingo Crystal";
    }

    public void readJson(JsonObject json) {
        this.objectiveProbability = Adapters.FLOAT.readJson(json.get("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
        this.sealCount = Adapters.INT.readJson(json.get("sealCount")).orElse(1);
    }
}

