/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;

public class IMCHandler {
    public static void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            String sender = message.senderModId();
            Object obj = message.messageSupplier().get();
            switch (message.method()) {
                case "RegisterMarketCategory": {
                    if (obj instanceof CompoundTag) {
                        CompoundTag tagCompound = (CompoundTag)obj;
                        ResourceLocation registryName = new ResourceLocation(tagCompound.m_128461_("RegistryName"));
                        if (registryName.m_135827_().equals(sender)) {
                            String tooltipLangKey = tagCompound.m_128425_("Tooltip", 8) ? tagCompound.m_128461_("Tooltip") : "gui.farmingforblockheads:market.tooltip_none";
                            ItemStack icon = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Icon"));
                            int sortIndex = tagCompound.m_128451_("SortIndex");
                            FarmingForBlockheadsAPI.registerMarketCategory(registryName, tooltipLangKey, icon, sortIndex);
                            break;
                        }
                        FarmingForBlockheads.logger.error("IMC API Error: Market category must be prefixed by your mod id (from {})", (Object)sender);
                        break;
                    }
                    FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry expects NBT (from {})", (Object)sender);
                    break;
                }
                case "RegisterMarketEntry": {
                    if (obj instanceof CompoundTag) {
                        CompoundTag tagCompound = (CompoundTag)obj;
                        if (!tagCompound.m_128425_("OutputItem", 10)) {
                            FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry requires OutputItem tag (from {})", (Object)sender);
                            break;
                        }
                        if (!tagCompound.m_128425_("CostItem", 10)) {
                            FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry requires CostItem tag (from {})", (Object)sender);
                            break;
                        }
                        ItemStack outputItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("OutputItem"));
                        ItemStack costItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("CostItem"));
                        ResourceLocation categoryId = tagCompound.m_128425_("Category", 8) ? new ResourceLocation(tagCompound.m_128461_("Category")) : FarmingForBlockheadsAPI.MARKET_CATEGORY_OTHER;
                        IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategory(categoryId);
                        if (category != null) {
                            FarmingForBlockheadsAPI.registerMarketEntry(outputItem, costItem, category);
                            break;
                        }
                        FarmingForBlockheads.logger.error("IMC API Error: Market category {} does not exist (from {})", (Object)categoryId, (Object)sender);
                        break;
                    }
                    FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry expects NBT (from {})", (Object)sender);
                }
            }
        });
    }
}

