/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.block.entity.MarketBlockEntity;
import net.blay09.mods.farmingforblockheads.entity.MerchantEntity;
import net.blay09.mods.farmingforblockheads.entity.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MarketBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape RENDER_SHAPE = Block.m_49796_((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public MarketBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.0f));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MarketBlockEntity(pos, state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext useContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)useContext.m_8125_().m_122424_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos entityPos = pos.m_142300_(facing.m_122424_());
        MerchantEntity.SpawnAnimationType spawnAnimationType = MerchantEntity.SpawnAnimationType.MAGIC;
        if (level.m_46861_(entityPos)) {
            spawnAnimationType = MerchantEntity.SpawnAnimationType.FALLING;
        } else if (!level.m_46859_(entityPos.m_7495_())) {
            spawnAnimationType = MerchantEntity.SpawnAnimationType.DIGGING;
        }
        if (!level.f_46443_) {
            MerchantEntity merchant = new MerchantEntity((EntityType<MerchantEntity>)((EntityType)ModEntities.merchant.get()), level);
            merchant.setMarket(pos, facing);
            merchant.setToFacingAngle();
            merchant.setSpawnAnimation(spawnAnimationType);
            if (level.m_46861_(entityPos)) {
                merchant.m_6034_((double)entityPos.m_123341_() + 0.5, entityPos.m_123342_() + 172, (double)entityPos.m_123343_() + 0.5);
            } else if (!level.m_46859_(entityPos.m_7495_())) {
                merchant.m_6034_((double)entityPos.m_123341_() + 0.5, entityPos.m_123342_(), (double)entityPos.m_123343_() + 0.5);
            } else {
                merchant.m_6034_((double)entityPos.m_123341_() + 0.5, entityPos.m_123342_(), (double)entityPos.m_123343_() + 0.5);
            }
            level.m_7967_((Entity)merchant);
            merchant.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity tileEntity;
        if (!level.f_46443_ && (tileEntity = level.m_7702_(pos)) instanceof MarketBlockEntity) {
            MarketBlockEntity market = (MarketBlockEntity)tileEntity;
            Balm.getNetworking().openGui(player, (MenuProvider)market);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54846_(facing).m_55954_(facing));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return RENDER_SHAPE;
    }
}

