/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MarketCategory
implements IRecipeCategory<IMarketEntry> {
    public static final ResourceLocation UID = new ResourceLocation("farmingforblockheads:market");
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmingforblockheads", "textures/gui/jei_market.png");
    private final IDrawable icon;
    private final IDrawableStatic background;

    public MarketCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.market));
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 86, 48);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends IMarketEntry> getRecipeClass() {
        return IMarketEntry.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("jei." + UID);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IMarketEntry marketRecipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)marketRecipe.getCostItem());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)marketRecipe.getOutputItem());
    }

    public void setRecipe(IRecipeLayout recipeLayout, IMarketEntry recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 15, 12);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 53, 12);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(IMarketEntry recipe, PoseStack poseStack, double mouseX, double mouseY) {
        Component costText = this.getFormattedCostString(recipe);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92852_((FormattedText)costText);
        fontRenderer.m_92744_(poseStack, costText.m_7532_(), 42.0f - (float)stringWidth / 2.0f, 35.0f, 0xFFFFFF);
    }

    private Component getFormattedCostString(IMarketEntry entry) {
        TranslatableComponent result = new TranslatableComponent("gui.farmingforblockheads:market.cost", new Object[]{entry.getCostItem().m_41613_(), entry.getCostItem().m_41611_()});
        ChatFormatting color = ChatFormatting.GREEN;
        if (entry.getCostItem().m_41720_() == Items.f_42415_) {
            color = ChatFormatting.AQUA;
        }
        result.m_130940_(color);
        return result;
    }
}

