/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin.networkstats;

import com.connectivity.Connectivity;
import com.connectivity.networkstats.INamedPacket;
import com.connectivity.networkstats.NetworkStatGatherer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.protocol.Packet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketEncoder.class})
public class NettyPacketEncoderMixin {
    @Inject(method={"encode"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/Packet;write(Lnet/minecraft/network/FriendlyByteBuf;)V", shift=At.Shift.AFTER)})
    private void onEncode(ChannelHandlerContext channelHandlerContext, Packet<?> packet, ByteBuf packetBuffer, CallbackInfo ci) {
        String name = packet.getClass().getSimpleName();
        if (packet instanceof INamedPacket && !((INamedPacket)packet).getName().isEmpty()) {
            name = ((INamedPacket)packet).getName();
        }
        NetworkStatGatherer.add(channelHandlerContext.channel().remoteAddress().toString(), name, packetBuffer.writerIndex());
    }

    @Inject(method={"encode(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/protocol/Packet;Lio/netty/buffer/ByteBuf;)V"}, at={@At(value="INVOKE", target="Ljava/io/IOException;<init>(Ljava/lang/String;)V")})
    public void onNoPacket(ChannelHandlerContext j, Packet<?> packet, ByteBuf friendlybytebuf, CallbackInfo ci) {
        String name = packet.getClass().getSimpleName();
        if (packet instanceof INamedPacket && !((INamedPacket)packet).getName().isEmpty()) {
            name = ((INamedPacket)packet).getName();
        }
        Connectivity.LOGGER.warn("Packet not registered: " + name);
    }
}

