/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackIdSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackNameSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackQuantitySorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;
import org.lwjgl.opengl.GL11;

public class IngredientComponentTerminalStorageHandlerItemStack
implements IIngredientComponentTerminalStorageHandler<ItemStack, Integer> {
    private final IngredientComponent<ItemStack, Integer> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerItemStack(IngredientComponent<ItemStack, Integer> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<ItemStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Blocks.f_50087_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(PoseStack matrixStack, ItemStack instance, long maxQuantity, @Nullable String label, AbstractContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<Component> additionalTooltipLines) {
        ItemStack instanceCopy = instance.m_41777_();
        RenderItemExtendedSlotCount renderItem = RenderItemExtendedSlotCount.getInstance();
        matrixStack.m_85836_();
        GlStateManager.m_84525_();
        GlStateManager.m_84328_((int)770, (int)771);
        Lighting.m_84931_();
        GlStateManager.m_84513_();
        GL11.glEnable((int)2929);
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            Minecraft.m_91087_().m_91291_().m_115203_(instanceCopy, x, y);
            renderItem.m_115174_(Minecraft.m_91087_().f_91062_, instanceCopy, x, y, label);
        } else {
            GuiHelpers.renderTooltip((AbstractContainerScreen)gui, (PoseStack)matrixStack, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                List lines = instanceCopy.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                if (additionalTooltipLines != null) {
                    lines.addAll(additionalTooltipLines);
                }
                this.addQuantityTooltip(lines, instanceCopy);
                return lines;
            });
        }
        Lighting.m_84930_();
        matrixStack.m_85849_();
    }

    @Override
    public String formatQuantity(ItemStack instance) {
        return String.format(Locale.ROOT, "%,d", instance.m_41613_());
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack != null;
    }

    @Override
    public ItemStack getInstance(ItemStack itemStack) {
        return itemStack;
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return itemStack.m_41741_();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageItemInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageItemIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<ItemStack, Integer> storage, ItemStack maxInstance, Player player) {
        ItemStack extracted = (ItemStack)storage.extract((Object)maxInstance, (Object)13, false);
        if (!extracted.m_41619_()) {
            player.m_36176_(extracted, true);
        }
        return extracted.m_41613_();
    }

    @Override
    public ItemStack insertIntoContainer(IIngredientComponentStorage<ItemStack, Integer> storage, AbstractContainerMenu container, int containerSlotIndex, ItemStack maxInstance, @Nullable Player player, boolean transferFullSelection) {
        int newCount;
        int inserted;
        ItemStack playerStack;
        ItemStack extracted;
        long movedTotal;
        ItemStack moved;
        ItemStack containerStack;
        IIngredientMatcher matcher = IngredientComponent.ITEMSTACK.getMatcher();
        if (maxInstance.m_41613_() > 64) {
            maxInstance.m_41764_(64);
        }
        Slot containerSlot = container.m_38853_(containerSlotIndex);
        if (transferFullSelection && player != null && container.m_142621_().m_41619_() && !(containerStack = containerSlot.m_7993_()).m_41619_() && !matcher.matches((Object)containerStack, (Object)maxInstance, (Object)((Integer)matcher.getExactMatchNoQuantityCondition())) && containerSlot.m_8010_(player)) {
            container.m_142503_(containerStack);
            containerSlot.m_142406_(player, containerStack);
            containerSlot.m_5852_(ItemStack.f_41583_);
        }
        long requiredQuantity = matcher.getQuantity((Object)maxInstance);
        for (movedTotal = 0L; movedTotal < requiredQuantity && !(extracted = (ItemStack)storage.extract((Object)maxInstance, (Object)((Integer)matcher.getExactMatchNoQuantityCondition()), true)).m_41619_() && ((playerStack = containerSlot.m_7993_()).m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)extracted, (ItemStack)playerStack)) && containerSlot.m_5857_(extracted) && !(moved = (ItemStack)storage.extract((Object)((ItemStack)matcher.withQuantity((Object)maxInstance, (long)(inserted = (newCount = Math.min(playerStack.m_41613_() + extracted.m_41613_(), extracted.m_41741_())) - playerStack.m_41613_()))), (Object)((Integer)matcher.getExactMatchNoQuantityCondition()), false)).m_41619_(); movedTotal += (long)moved.m_41613_()) {
            containerSlot.m_5852_(((ItemStack)matcher.withQuantity((Object)maxInstance, (long)(containerSlot.m_7993_().m_41613_() + moved.m_41613_()))).m_41777_());
            container.m_38946_();
        }
        return (ItemStack)matcher.withQuantity((Object)maxInstance, movedTotal);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<ItemStack, Integer> storage, AbstractContainerMenu container, Inventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = (ItemStack)IngredientComponent.ITEMSTACK.getMatcher().withQuantity((Object)container.m_142621_(), moveQuantityPlayerSlot);
        int remaining = ((ItemStack)storage.insert((Object)playerStack.m_41777_(), false)).m_41613_();
        int moved = (int)(moveQuantityPlayerSlot - (long)remaining);
        container.m_142621_().m_41774_(moved);
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<ItemStack, Integer> storage, AbstractContainerMenu container, int containerSlot, Inventory playerInventory, int limit) {
        ItemStack toMove;
        Slot slot = container.m_38853_(containerSlot);
        if (slot.m_8010_(playerInventory.f_35978_) && !(toMove = slot.m_6201_(limit == -1 ? Integer.MAX_VALUE : limit)).m_41619_()) {
            ItemStack remainingStack = (ItemStack)storage.insert((Object)toMove, false);
            if (!remainingStack.m_41619_()) {
                if (!slot.m_6657_()) {
                    slot.m_5852_(remainingStack);
                } else {
                    playerInventory.m_36054_(remainingStack);
                }
            }
            container.m_38946_();
        }
    }

    @Override
    public long getActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container) {
        return container.m_142621_().m_41613_();
    }

    @Override
    public void drainActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container, long quantity) {
        container.m_142621_().m_41774_((int)quantity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<ItemStack> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return switch (searchMode) {
            default -> throw new IncompatibleClassChangeError();
            case SearchMode.MOD -> i -> Optional.ofNullable(i.m_41720_().getCreatorModId(i)).orElse("minecraft").toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            case SearchMode.TOOLTIP -> i -> i.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().anyMatch(s -> s.getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*"));
            case SearchMode.TAG -> i -> ForgeRegistries.ITEMS.tags().getReverseTag((IForgeRegistryEntry)i.m_41720_()).map(reverseTag -> reverseTag.getTagKeys().filter(tag -> tag.f_203868_().toString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*")).anyMatch(tag -> !ForgeRegistries.ITEMS.tags().getTag(tag).isEmpty())).orElse(false);
            case SearchMode.DEFAULT -> i -> i.m_41786_().getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
        };
    }

    @Override
    public Collection<IIngredientInstanceSorter<ItemStack>> getInstanceSorters() {
        return Lists.newArrayList((Object[])new IIngredientInstanceSorter[]{new ItemStackNameSorter(), new ItemStackIdSorter(), new ItemStackQuantitySorter()});
    }
}

