/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobs;
import org.cyclops.integratedterminals.network.packet.CancelCraftingJobPacket;
import org.cyclops.integratedterminals.network.packet.OpenCraftingJobsPlanGuiPacket;

public class ContainerScreenTerminalCraftingJobs
extends ContainerScreenExtended<ContainerTerminalCraftingJobs> {
    public static int OUTPUT_SLOT_X = 8;
    public static int OUTPUT_SLOT_Y = 17;
    public static int LINE_WIDTH = 221;
    private final Player player;
    private WidgetScrollBar scrollBar;
    private int firstRow;

    public ContainerScreenTerminalCraftingJobs(ContainerTerminalCraftingJobs container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.f_35978_;
    }

    public void m_7856_() {
        super.m_7856_();
        this.scrollBar = new WidgetScrollBar(this.f_97735_ + 236, this.f_97736_ + 18, 178, (Component)new TranslatableComponent("gui.cyclopscore.scrollbar"), this::setFirstRow, 10);
        this.scrollBar.setTotalRows(((ContainerTerminalCraftingJobs)this.m_6262_()).getCraftingJobs().size() - 1);
        this.m_142416_((GuiEventListener)new ButtonText(this.f_97735_ + 70, this.f_97736_ + 198, 120, 20, (Component)new TranslatableComponent("gui.integratedterminals.terminal_crafting_job.craftingplan.cancel_all"), (Component)new TranslatableComponent("gui.integratedterminals.terminal_crafting_job.craftingplan.cancel_all"), b -> this.cancelCraftingJobs(), true));
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/crafting_plan.png");
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.drawCraftingPlans(matrixStack, this.f_97735_, this.f_97736_, partialTicks, mouseX - this.f_97735_, mouseY - this.f_97736_, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND);
        ContainerScreenTerminalCraftingJobs.m_93236_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"parttype.integratedterminals.terminal_crafting_job", (Object[])new Object[0]), (int)(this.f_97735_ + 8), (int)(this.f_97736_ + 5), (int)0xFFFFFF);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.drawCraftingPlans(matrixStack, 0, 0, 0.0f, mouseX, mouseY, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND);
    }

    protected List<HandlerWrappedTerminalCraftingPlan> getVisiblePlans() {
        return ((ContainerTerminalCraftingJobs)this.m_6262_()).getCraftingJobs().subList(this.firstRow, Math.min(((ContainerTerminalCraftingJobs)this.m_6262_()).getCraftingJobs().size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    protected void drawCraftingPlans(PoseStack matrixStack, int x, int y, float partialTicks, int mouseX, int mouseY, ContainerScreenTerminalStorage.DrawLayer layer) {
        int offsetY = OUTPUT_SLOT_Y;
        for (HandlerWrappedTerminalCraftingPlan craftingPlan : this.getVisiblePlans()) {
            this.drawCraftingPlan(matrixStack, craftingPlan, x + OUTPUT_SLOT_X, y + offsetY, layer, partialTicks, mouseX, mouseY);
            offsetY += GuiHelpers.SLOT_SIZE;
        }
    }

    protected void drawCraftingPlan(PoseStack matrixStack, HandlerWrappedTerminalCraftingPlan craftingPlan, int x, int y, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int xOriginal = x;
        ITerminalCraftingPlan plan = craftingPlan.getCraftingPlan();
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND && RenderHelpers.isPointInRegion((int)(x - this.f_97735_), (int)(y - this.f_97736_), (int)LINE_WIDTH, (int)GuiHelpers.SLOT_SIZE, (double)mouseX, (double)mouseY)) {
            ContainerScreenTerminalCraftingJobs.m_93172_((PoseStack)matrixStack, (int)(x + 1), (int)(y + 1), (int)(x + LINE_WIDTH + 1), (int)(y + GuiHelpers.SLOT_SIZE), (int)-2130706433);
        }
        x += 4;
        for (IPrototypedIngredient<?, ?> output : plan.getOutputs()) {
            IngredientComponent ingredientComponent = output.getComponent();
            long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
            int finalX = x;
            ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY).ifPresent(h -> h.drawInstance(matrixStack, output.getPrototype(), quantity, GuiHelpers.quantityToScaledString((long)quantity), (AbstractContainerScreen)this, layer, partialTick, finalX, y + 1, mouseX, mouseY, null));
            x += GuiHelpers.SLOT_SIZE_INNER;
        }
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            long tickDuration;
            String statusString = L10NHelpers.localize((String)"gui.integratedterminals.craftingplan.status", (Object[])new Object[]{L10NHelpers.localize((String)("gui.integratedterminals.craftingplan.status." + plan.getStatus().name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0])});
            RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)this.f_96547_, (String)statusString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
            int dependencies = ContainerScreenTerminalCraftingJobs.getDependencies(plan);
            String dependenciesString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.dependencies", (Object[])new Object[]{dependencies});
            RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)this.f_96547_, (String)dependenciesString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 7), (float)0.5f, (int)0xFFFFFF);
            if (plan.getChannel() != -1) {
                String channelString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", (Object[])new Object[]{plan.getChannel()});
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)this.f_96547_, (String)channelString, (int)(xOriginal + LINE_WIDTH - 40), (int)(y + 7), (float)0.5f, (int)0xFFFFFF);
            }
            if ((tickDuration = plan.getTickDuration()) >= 0L) {
                String durationString = GuiCraftingPlan.getDurationString(tickDuration);
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)this.f_96547_, (String)durationString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 13), (float)0.5f, (int)0xFFFFFF);
            }
        }
    }

    protected static int getDependencies(ITerminalCraftingPlan<?> plan) {
        int count = 1;
        for (ITerminalCraftingPlan<?> dependency : plan.getDependencies()) {
            count += ContainerScreenTerminalCraftingJobs.getDependencies(dependency);
        }
        return count;
    }

    private void cancelCraftingJobs() {
        for (HandlerWrappedTerminalCraftingPlan craftingJob : ((ContainerTerminalCraftingJobs)this.m_6262_()).getCraftingJobs()) {
            PartPos center = ((PartTarget)((ContainerTerminalCraftingJobs)this.m_6262_()).getTarget().get()).getCenter();
            CraftingJobGuiData data = new CraftingJobGuiData(center.getPos().getBlockPos(), center.getSide(), ((ContainerTerminalCraftingJobs)this.m_6262_()).getChannel(), craftingJob.getHandler(), craftingJob.getCraftingPlan().getId());
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new CancelCraftingJobPacket(data));
        }
        this.player.m_6915_();
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingPlan getHoveredPlan(double mouseX, double mouseY) {
        mouseX -= (double)this.f_97735_;
        mouseY -= (double)this.f_97736_;
        if (mouseX > (double)OUTPUT_SLOT_X && mouseX < (double)(OUTPUT_SLOT_X + LINE_WIDTH) && mouseY > (double)OUTPUT_SLOT_Y && mouseY < (double)(OUTPUT_SLOT_Y + GuiHelpers.SLOT_SIZE * this.scrollBar.getVisibleRows())) {
            int index = ((int)mouseY - OUTPUT_SLOT_Y) / GuiHelpers.SLOT_SIZE;
            List<HandlerWrappedTerminalCraftingPlan> plans = this.getVisiblePlans();
            if (index >= 0 && index < plans.size()) {
                return plans.get(index);
            }
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        HandlerWrappedTerminalCraftingPlan plan = this.getHoveredPlan(mouseX, mouseY);
        if (plan != null) {
            PartPos pos = ((PartTarget)((ContainerTerminalCraftingJobs)this.m_6262_()).getTarget().get()).getCenter();
            OpenCraftingJobsPlanGuiPacket.send(pos.getPos().getBlockPos(), pos.getSide(), ((ContainerTerminalCraftingJobs)this.m_6262_()).getChannel(), plan);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        return this.m_7222_() != null && this.m_7282_() && mouseButton == 0 && this.m_7222_().m_7979_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.m_7979_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (valueId == ((ContainerTerminalCraftingJobs)this.m_6262_()).getValueIdCraftingJobs()) {
            this.m_7856_();
        }
    }
}

