/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalRowColumnProvider;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageScreenSizeEvent;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonScaleGui<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentCommon<T, ?>, ButtonImage> {
    private final TerminalStorageState state;
    private final String buttonName;
    private final ITerminalStorageTabClient<?> clientTab;
    private GuiScale scale;

    public TerminalButtonScaleGui(TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.state = state;
        this.buttonName = "gui_scale";
        this.clientTab = clientTab;
        this.reloadFromState();
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton("minecraft:itemstack", this.buttonName)) {
            CompoundTag data = (CompoundTag)this.state.getButton("minecraft:itemstack", this.buttonName);
            this.scale = GuiScale.values()[data.m_128451_("scale")];
        } else {
            this.scale = GuiScale.SCALE_XY;
        }
    }

    @Override
    public ButtonImage createButton(int x, int y) {
        return new ButtonImage(x, y, (Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.scale"), b -> {}, new IImage[]{this.scale == GuiScale.SCALE_XY ? Images.BUTTON_BACKGROUND_INACTIVE : Images.BUTTON_BACKGROUND_ACTIVE, this.scale.getImage()});
    }

    @Override
    public void onClick(TerminalStorageTabIngredientComponentClient<T, ?> clientTab, @Nullable TerminalStorageTabIngredientComponentCommon<T, ?> commonTab, ButtonImage guiButton, int channel, int mouseButton) {
        this.scale = mouseButton == 0 ? GuiScale.values()[(this.scale.ordinal() + 1) % GuiScale.values().length] : GuiScale.SCALE_XY;
        CompoundTag data = new CompoundTag();
        data.m_128405_("scale", this.scale.ordinal());
        this.state.setButton(clientTab.getTabSettingsName().toString(), this.buttonName, (Tag)data);
        clientTab.resetScale();
    }

    @Override
    public String getTranslationKey() {
        return "gui.integratedterminals.terminal_storage.scale";
    }

    @Override
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        lines.add((Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.scale.info").m_130940_(ChatFormatting.GRAY));
        lines.add((Component)new TranslatableComponent(this.scale.getLabel()));
    }

    public ITerminalRowColumnProvider getRowColumnProvider() {
        return this.scale.getRowColumnProvider();
    }

    public static enum GuiScale {
        SCALE_XY((IImage)Images.BUTTON_MIDDLE_SCALE_XY, "gui.integratedterminals.terminal_storage.scale.scalexy", () -> {
            Pair<Integer, Integer> widthHeight = TerminalStorageScreenSizeEvent.getWidthHeight();
            return new ITerminalRowColumnProvider.RowsAndColumns((int)Math.min(Math.max(1.0, Math.ceil(((Integer)widthHeight.getRight() - 146) / GuiHelpers.SLOT_SIZE)), (double)GeneralConfig.guiStorageScaleMaxRows), (int)Math.min(Math.max(1.0, Math.ceil(((Integer)widthHeight.getLeft() - 56) / GuiHelpers.SLOT_SIZE)), (double)GeneralConfig.guiStorageScaleMaxColumns));
        }),
        SCALE_Y((IImage)Images.BUTTON_MIDDLE_SCALE_Y, "gui.integratedterminals.terminal_storage.scale.scaley", () -> new ITerminalRowColumnProvider.RowsAndColumns((int)Math.min(Math.max(1.0, Math.ceil(((Integer)TerminalStorageScreenSizeEvent.getWidthHeight().getRight() - 146) / GuiHelpers.SLOT_SIZE)), (double)GeneralConfig.guiStorageScaleMaxRows), GeneralConfig.guiStorageScaleHeightColumns)),
        SCALE_X((IImage)Images.BUTTON_MIDDLE_SCALE_X, "gui.integratedterminals.terminal_storage.scale.scalex", () -> new ITerminalRowColumnProvider.RowsAndColumns(GeneralConfig.guiStorageScaleWidthRows, (int)Math.min(Math.max(1.0, Math.ceil(((Integer)TerminalStorageScreenSizeEvent.getWidthHeight().getLeft() - 56) / GuiHelpers.SLOT_SIZE)), (double)GeneralConfig.guiStorageScaleMaxColumns))),
        SMALL((IImage)Images.BUTTON_MIDDLE_SCALE_SMALL, "gui.integratedterminals.terminal_storage.scale.small", () -> new ITerminalRowColumnProvider.RowsAndColumns(GeneralConfig.guiStorageScaleSmallRows, GeneralConfig.guiStorageScaleSmallColumns)),
        MEDIUM((IImage)Images.BUTTON_MIDDLE_SCALE_MEDIUM, "gui.integratedterminals.terminal_storage.scale.medium", () -> new ITerminalRowColumnProvider.RowsAndColumns(GeneralConfig.guiStorageScaleMediumRows, GeneralConfig.guiStorageScaleMediumColumns)),
        LARGE((IImage)Images.BUTTON_MIDDLE_SCALE_LARGE, "gui.integratedterminals.terminal_storage.scale.large", () -> new ITerminalRowColumnProvider.RowsAndColumns(GeneralConfig.guiStorageScaleLargeRows, GeneralConfig.guiStorageScaleLargeColumns));

        @Nullable
        private final IImage image;
        private final String label;
        private final ITerminalRowColumnProvider rowColumnProvider;

        private GuiScale(IImage image, String label, ITerminalRowColumnProvider rowColumnProvider) {
            this.image = image;
            this.label = label;
            this.rowColumnProvider = rowColumnProvider;
        }

        @Nullable
        public IImage getImage() {
            return this.image;
        }

        public String getLabel() {
            return this.label;
        }

        public ITerminalRowColumnProvider getRowColumnProvider() {
            return this.rowColumnProvider;
        }
    }
}

