/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.client.gui.ButtonSort;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonSort<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, ITerminalStorageTabCommon, ButtonSort> {
    private final IIngredientInstanceSorter<T> instanceSorter;
    private final TerminalStorageState state;
    private final String buttonName;
    private final ITerminalStorageTabClient<?> clientTab;
    private Comparator<T> effectiveSorter;
    private boolean active;
    private boolean descending;

    public TerminalButtonSort(IIngredientInstanceSorter<T> instanceSorter, TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.instanceSorter = instanceSorter;
        this.state = state;
        this.buttonName = "sort_" + instanceSorter.getTranslationKey();
        this.clientTab = clientTab;
        this.reloadFromState();
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton(this.clientTab.getTabSettingsName().toString(), this.buttonName)) {
            CompoundTag data = (CompoundTag)this.state.getButton(this.clientTab.getTabSettingsName().toString(), this.buttonName);
            this.active = data.m_128471_("active");
            this.descending = data.m_128471_("descending");
        } else {
            this.active = false;
            this.descending = true;
        }
        this.updateSorter();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ButtonSort createButton(int x, int y) {
        return new ButtonSort(x, y, (Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.sort"), b -> {}, this.instanceSorter.getIcon(), this.active, this.descending);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClick(TerminalStorageTabIngredientComponentClient<T, ?> clientTab, ITerminalStorageTabCommon commonTab, ButtonSort guiButton, int channel, int mouseButton) {
        if (mouseButton == 0) {
            if (this.active) {
                if (this.descending) {
                    this.descending = false;
                } else {
                    this.active = false;
                }
            } else {
                this.active = true;
                this.descending = true;
            }
        } else {
            this.active = false;
            this.descending = true;
        }
        CompoundTag data = new CompoundTag();
        data.m_128379_("active", this.active);
        data.m_128379_("descending", this.descending);
        this.state.setButton(clientTab.getTabSettingsName().toString(), this.buttonName, (Tag)data);
        this.updateSorter();
        clientTab.resetFilteredIngredientsViews(channel);
    }

    protected void updateSorter() {
        this.effectiveSorter = this.active ? (this.descending ? this.instanceSorter.reversed() : this.instanceSorter) : null;
    }

    @Override
    public String getTranslationKey() {
        return this.instanceSorter.getTranslationKey();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        this.instanceSorter.getTooltip(player, tooltipFlag, lines);
        if (this.active) {
            lines.add((Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.sort.order.label", new Object[]{new TranslatableComponent(this.descending ? "gui.integratedterminals.terminal_storage.sort.order.descending" : "gui.integratedterminals.terminal_storage.sort.order.ascending")}).m_130940_(ChatFormatting.ITALIC));
        } else {
            lines.add((Component)new TranslatableComponent("general.cyclopscore.info.disabled").m_130940_(ChatFormatting.ITALIC));
        }
    }

    @Nullable
    public Comparator<T> getEffectiveSorter() {
        return this.effectiveSorter;
    }
}

