/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTab;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabServer;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabCommonLoadSlotsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabs;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.network.packet.TerminalStorageChangeGuiState;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingJobAmountGuiPacket;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingPlanGuiPacket;

public abstract class ContainerTerminalStorageBase<L>
extends InventoryContainer
implements IDirtyMarkListener {
    public static final String BUTTON_SET_DEFAULTS = "button_set_defaults";
    private final Level world;
    private final Map<String, ITerminalStorageTabClient<?>> tabsClient;
    private final Map<String, ITerminalStorageTabServer> tabsServer;
    private final Map<String, ITerminalStorageTabCommon> tabsCommon;
    private final Map<String, List<Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>>> tabSlots;
    private final TerminalStorageState terminalStorageState;
    private final Optional<INetwork> network;
    private final Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventory;
    private int selectedTabIndexValueId;
    private int selectedChannelValueId;
    private boolean serverTabsInitialized;
    private final List<String> channelStrings;
    private String channelAllLabel;
    @OnlyIn(value=Dist.CLIENT)
    public ContainerScreenTerminalStorage screen;

    public ContainerTerminalStorageBase(@Nullable MenuType<?> type, int id, Inventory playerInventory, Optional<InitTabData> initTabData, TerminalStorageState terminalStorageState, Optional<INetwork> network, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventory) {
        super(type, id, playerInventory, (Container)new SimpleContainer(new ItemStack[0]));
        this.world = this.player.m_20193_();
        this.tabsClient = Maps.newLinkedHashMap();
        this.tabsServer = Maps.newLinkedHashMap();
        this.tabsCommon = Maps.newLinkedHashMap();
        this.tabSlots = Maps.newHashMap();
        this.terminalStorageState = terminalStorageState;
        this.network = network;
        this.variableInventory = variableInventory;
        this.selectedTabIndexValueId = this.getNextValueId();
        this.selectedChannelValueId = this.getNextValueId();
        this.serverTabsInitialized = false;
        this.addPlayerInventory(this.player.m_150109_(), 31, 143);
        this.addInventoryAndOffHand(this.player.m_150109_());
        this.channelAllLabel = "All";
        this.channelStrings = Lists.newArrayList((Object[])new String[]{this.channelAllLabel});
        for (ITerminalStorageTab tab : TerminalStorageTabs.REGISTRY.getTabs()) {
            ITerminalStorageTabCommon commonTab;
            String tabId = tab.getName().toString();
            if (this.getWorld().m_5776_()) {
                this.tabsClient.put(tabId, tab.createClientTab(this, this.player));
            } else {
                this.tabsServer.put(tabId, tab.createServerTab(this, this.player, network.get()));
            }
            if ((commonTab = tab.createCommonTab(this, this.player)) == null) continue;
            this.tabsCommon.put(tabId, commonTab);
            int slotStartIndex = this.f_38839_.size();
            List<Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>> slots = commonTab.loadSlots((AbstractContainerMenu)this, slotStartIndex, this.player, this.getVariableInventory());
            TerminalStorageTabCommonLoadSlotsEvent loadSlotsEvent = new TerminalStorageTabCommonLoadSlotsEvent(commonTab, this, slots);
            MinecraftForge.EVENT_BUS.post((Event)loadSlotsEvent);
            slots = loadSlotsEvent.getSlots();
            this.tabSlots.put(tabId, slots);
            for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : slots) {
                if (((Slot)slot.getLeft()).f_40219_ != 0) continue;
                this.m_38897_((Slot)slot.getLeft());
            }
        }
        for (ITerminalStorageTabCommon tabCommon : this.tabsCommon.values()) {
            this.disableSlots(tabCommon.getName().toString());
        }
        if (this.player.f_19853_.m_5776_()) {
            TerminalStorageState state = this.getGuiState();
            this.setSelectedTab(state.hasTab() ? state.getTab() : (this.getTabsClient().size() > 0 ? ((ITerminalStorageTabClient)Iterables.getFirst(this.getTabsClient().values(), null)).getName().toString() : null));
            this.setSelectedChannel(-1);
        } else {
            this.setSelectedTab(null);
            this.setSelectedChannel(-1);
        }
        initTabData.ifPresent(d -> {
            this.setSelectedTab(d.getTabName());
            this.setSelectedChannel(d.getChannel());
        });
        this.putButtonAction(BUTTON_SET_DEFAULTS, (s, containerExtended) -> {
            if (!playerInventory.f_35978_.f_19853_.m_5776_()) {
                TerminalStorageState.setPlayerDefault(playerInventory.f_35978_, this.getGuiState());
            }
        });
    }

    protected void addInventoryAndOffHand(Inventory inventory) {
        EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = SLOT_IDS[k];
            this.m_38897_(new Slot((Container)inventory, 39 - k, -7 + k % 2 * 18, 152 + (int)Math.floor(k / 2) * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack p_39746_) {
                    return p_39746_.canEquip(equipmentslot, (Entity)ContainerTerminalStorageBase.this.player);
                }

                public boolean m_8010_(Player p_39744_) {
                    ItemStack itemstack = this.m_7993_();
                    return !itemstack.m_41619_() && !p_39744_.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)itemstack) ? false : super.m_8010_(p_39744_);
                }

                public com.mojang.datafixers.util.Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return com.mojang.datafixers.util.Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.m_20749_()]);
                }
            });
        }
        this.m_38897_(new Slot((Container)inventory, 40, 2, 201){

            public com.mojang.datafixers.util.Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return com.mojang.datafixers.util.Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
    }

    public Optional<ITerminalStorageTabCommon.IVariableInventory> getVariableInventory() {
        return this.variableInventory;
    }

    public Optional<INetwork> getNetwork() {
        return this.network;
    }

    public abstract ITerminalStorageLocation<L> getLocation();

    public abstract L getLocationInstance();

    public void onDirty() {
    }

    public Level getWorld() {
        return this.world;
    }

    public TerminalStorageState getGuiState() {
        return this.terminalStorageState;
    }

    public void sendGuiStateToServer() {
        if (this.player.f_19853_.m_5776_()) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageChangeGuiState(this.getGuiState()));
        }
    }

    public int getNextValueId() {
        return super.getNextValueId();
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.serverTabsInitialized) {
            for (ITerminalStorageTabServer iTerminalStorageTabServer : this.tabsServer.values()) {
                iTerminalStorageTabServer.init();
            }
            this.serverTabsInitialized = true;
        }
        for (ITerminalStorageTabCommon iTerminalStorageTabCommon : this.tabsCommon.values()) {
            iTerminalStorageTabCommon.onUpdate((AbstractContainerMenu)this, this.player, this.getVariableInventory());
        }
        ITerminalStorageTabServer activeServerTab = this.getTabServer(this.getSelectedTab());
        if (activeServerTab != null) {
            activeServerTab.updateActive();
        }
    }

    public <T, M, L> void sendOpenCraftingPlanGuiPacketToServer(CraftingOptionGuiData<T, M, L> craftingOptionData) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingPlanGuiPacket<T, M, L>(craftingOptionData));
    }

    public <T, M, L> void sendOpenCraftingJobAmountGuiPacketToServer(CraftingOptionGuiData<T, M, L> craftingOptionData) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingJobAmountGuiPacket<T, M, L>(craftingOptionData));
    }

    public void m_6199_(Container inventoryIn) {
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (!this.getWorld().m_5776_() && this.serverTabsInitialized) {
            for (ITerminalStorageTabServer tab : this.tabsServer.values()) {
                tab.deInit();
            }
        }
    }

    protected int getSizeInventory() {
        return this.f_38839_.size() - this.player.m_150109_().f_35974_.size();
    }

    public List<Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>> getTabSlots(String tabName) {
        List<Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>> slots = this.tabSlots.get(tabName);
        if (slots == null) {
            return Collections.emptyList();
        }
        return slots;
    }

    public ItemStack m_7648_(Player player, int slotID) {
        Optional<ITerminalStorageTabClient<?>> tabOptional;
        if (player.m_183503_().f_46443_ && (tabOptional = this.screen.getSelectedClientTab()).isPresent() && !tabOptional.get().isQuickMovePrevented(slotID)) {
            tabOptional.get().handleClick((AbstractContainerMenu)this, this.getSelectedChannel(), -1, 0, false, false, slotID, true);
        }
        return ItemStack.f_41583_;
    }

    protected void enableSlots(String tabName) {
    }

    protected void disableSlots(String tabName) {
        List<Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>> slots = this.getTabSlots(tabName);
        if (slots != null) {
            for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : slots) {
                ContainerTerminalStorageBase.setSlotPosX((Slot)((Slot)slot.getLeft()), (int)Integer.MIN_VALUE);
                ContainerTerminalStorageBase.setSlotPosY((Slot)((Slot)slot.getLeft()), (int)Integer.MIN_VALUE);
            }
        }
    }

    public void setSelectedTab(@Nullable String selectedTab) {
        this.disableSlots(this.getSelectedTab());
        if (this.player.f_19853_.f_46443_) {
            ITerminalStorageTabClient previousTab = this.getTabClient(this.getSelectedTab());
            if (previousTab != null) {
                previousTab.onDeselect(this.getSelectedChannel());
            }
            this.getGuiState().setTab(selectedTab);
            ITerminalStorageTabClient newTab = this.getTabClient(selectedTab);
            if (newTab != null) {
                newTab.onSelect(this.getSelectedChannel());
            }
        }
        if (selectedTab != null) {
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.selectedTabIndexValueId, (String)selectedTab);
        }
        this.enableSlots(this.getSelectedTab());
    }

    @Nullable
    public String getSelectedTab() {
        return ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.selectedTabIndexValueId);
    }

    public void setSelectedChannel(int selectedChannel) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.selectedChannelValueId, (int)selectedChannel);
        this.refreshChannelStrings();
    }

    public int getSelectedChannel() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.selectedChannelValueId);
    }

    @Nullable
    public ITerminalStorageTabClient getTabClient(String id) {
        return this.tabsClient.get(id);
    }

    @Nullable
    public ITerminalStorageTabServer getTabServer(String id) {
        return this.tabsServer.get(id);
    }

    @Nullable
    public ITerminalStorageTabCommon getTabCommon(String id) {
        return this.tabsCommon.get(id);
    }

    public int getTabsClientCount() {
        return this.getTabsClient().size();
    }

    public Map<String, ITerminalStorageTabClient<?>> getTabsClient() {
        LinkedHashMap tabs = Maps.newLinkedHashMap();
        for (Map.Entry<String, ITerminalStorageTabClient<?>> entry : this.tabsClient.entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            tabs.put(entry.getKey(), entry.getValue());
        }
        return tabs;
    }

    public Map<String, ITerminalStorageTabCommon> getTabsCommon() {
        LinkedHashMap tabs = Maps.newLinkedHashMap();
        for (Map.Entry<String, ITerminalStorageTabCommon> entry : this.tabsCommon.entrySet()) {
            tabs.put(entry.getKey(), entry.getValue());
        }
        return tabs;
    }

    public Map<String, ITerminalStorageTabServer> getTabsServer() {
        return this.tabsServer;
    }

    public List<String> getChannelStrings() {
        return this.channelStrings;
    }

    public void refreshChannelStrings() {
        this.channelStrings.clear();
        this.channelStrings.add(this.channelAllLabel);
        ITerminalStorageTabClient<?> tab = this.tabsClient.get(this.getSelectedTab());
        if (tab != null) {
            for (int channel : tab.getChannels()) {
                this.channelStrings.add(String.valueOf(channel));
            }
        }
    }

    public abstract void onVariableContentsUpdated(INetwork var1, IVariable<?> var2);

    public static class InitTabData {
        private final String tabName;
        private final int channel;

        public InitTabData(String tabName, int channel) {
            this.tabName = tabName;
            this.channel = channel;
        }

        public String getTabName() {
            return this.tabName;
        }

        public int getChannel() {
            return this.channel;
        }

        public void writeToPacketBuffer(FriendlyByteBuf packetBuffer) {
            packetBuffer.m_130070_(this.tabName);
            packetBuffer.writeInt(this.channel);
        }

        public static InitTabData readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
            return new InitTabData(packetBuffer.m_130136_(Short.MAX_VALUE), packetBuffer.readInt());
        }
    }
}

