/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.CraftingJobStartException;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;

public abstract class ContainerTerminalStorageCraftingPlanBase<L>
extends InventoryContainer {
    public static final String BUTTON_START = "start";
    private static final ExecutorService WORKER_POOL = Executors.newFixedThreadPool(GeneralConfig.craftingPlannerThreads);
    private final CraftingOptionGuiData craftingOptionGuiData;
    private final int craftingPlanNotifierId;
    private final Level world;
    private boolean calculatedCraftingPlan;
    private ITerminalCraftingPlan craftingPlan;

    public ContainerTerminalStorageCraftingPlanBase(@Nullable MenuType<?> type, int id, Inventory playerInventory, CraftingOptionGuiData craftingOptionGuiData) {
        super(type, id, playerInventory, (Container)new SimpleContainer(new ItemStack[0]));
        this.craftingOptionGuiData = craftingOptionGuiData;
        this.craftingPlanNotifierId = this.getNextValueId();
        this.world = playerInventory.f_35978_.f_19853_;
        this.putButtonAction(BUTTON_START, (buttonId, container) -> this.startCraftingJob());
    }

    public abstract Optional<INetwork> getNetwork();

    public Level getWorld() {
        return this.world;
    }

    public CraftingOptionGuiData getCraftingOptionGuiData() {
        return this.craftingOptionGuiData;
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.player.f_19853_.f_46443_ && !this.calculatedCraftingPlan) {
            this.calculatedCraftingPlan = true;
            this.updateCraftingPlan();
        }
    }

    public int getCraftingPlanNotifierId() {
        return this.craftingPlanNotifierId;
    }

    protected void updateCraftingPlan() {
        HandlerWrappedTerminalCraftingOption craftingOptionWrapper = this.craftingOptionGuiData.getCraftingOption();
        this.getNetwork().ifPresent(network -> {
            if (GeneralConfig.craftingPlannerEnableMultithreading) {
                WORKER_POOL.execute(() -> {
                    BlockEntityHelpers.UNSAFE_BLOCK_ENTITY_GETTER = true;
                    this.updateCraftingPlanJob(craftingOptionWrapper, (INetwork)network);
                    BlockEntityHelpers.UNSAFE_BLOCK_ENTITY_GETTER = false;
                });
            } else {
                this.updateCraftingPlanJob(craftingOptionWrapper, (INetwork)network);
            }
        });
    }

    protected void updateCraftingPlanJob(HandlerWrappedTerminalCraftingOption craftingOptionWrapper, INetwork network) {
        this.setCraftingPlan(craftingOptionWrapper.getHandler().calculateCraftingPlan(network, this.craftingOptionGuiData.getChannel(), craftingOptionWrapper.getCraftingOption(), this.craftingOptionGuiData.getAmount()));
    }

    protected void setCraftingPlan(ITerminalCraftingPlan craftingPlan) {
        this.craftingPlan = craftingPlan;
        this.setValue(this.craftingPlanNotifierId, this.craftingOptionGuiData.getCraftingOption().getHandler().serializeCraftingPlan(this.craftingPlan));
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    private void startCraftingJob() {
        if (!this.getWorld().m_5776_() && this.craftingPlan != null) {
            this.getNetwork().ifPresent(network -> {
                try {
                    this.craftingOptionGuiData.getCraftingOption().getHandler().startCraftingJob((INetwork)network, this.craftingOptionGuiData.getChannel(), this.craftingPlan, (ServerPlayer)this.player);
                    this.craftingOptionGuiData.getLocation().openContainerFromServer(this.craftingOptionGuiData, this.getWorld(), (ServerPlayer)this.player);
                }
                catch (CraftingJobStartException e) {
                    this.craftingPlan.setError(e.getUnlocalizedError());
                    this.setCraftingPlan(this.craftingPlan);
                }
            });
        }
    }
}

