/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageScreenSizeEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientLoadButtonsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientSearchFieldUpdateEvent;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePart;
import org.cyclops.integratedterminals.part.PartTypes;
import org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage.TerminalStorageGuiHandler;
import org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage.TerminalStorageRecipeTransferHandler;
import org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage.button.TerminalButtonItemStackCraftingGridJeiSearchSync;

@JeiPlugin
public class JEIIntegratedTerminalsConfig
implements IModPlugin {
    public static ISubtypeManager subTypeManager;
    public static IJeiRuntime jeiRuntime;
    private boolean wasJeiVisible = false;

    public JEIIntegratedTerminalsConfig() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static int getItemStackMatchCondition(ItemStack itemStack) {
        String subTypeInfo = subTypeManager.getSubtypeInfo(itemStack, UidContext.Ingredient);
        return subTypeInfo == null ? 1 : 5;
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        subTypeManager = registration.getSubtypeManager();
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler(new TerminalStorageRecipeTransferHandler<ContainerTerminalStoragePart>(registration.getTransferHelper(), ContainerTerminalStoragePart.class));
        registration.addUniversalRecipeTransferHandler(new TerminalStorageRecipeTransferHandler<ContainerTerminalStorageItem>(registration.getTransferHelper(), ContainerTerminalStorageItem.class));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(ContainerScreenTerminalStorage.class, (IGuiContainerHandler)new TerminalStorageGuiHandler());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PartTypes.TERMINAL_STORAGE.getItem()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("integratedterminalscompat", "main");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIIntegratedTerminalsConfig.jeiRuntime = jeiRuntime;
    }

    @SubscribeEvent
    public void onTerminalStorageButtons(TerminalStorageTabClientLoadButtonsEvent event) {
        if (!event.getButtons().stream().anyMatch(button -> button instanceof TerminalButtonItemStackCraftingGridJeiSearchSync)) {
            event.getButtons().add(new TerminalButtonItemStackCraftingGridJeiSearchSync(event.getContainer().getGuiState(), event.getClientTab()));
        }
    }

    @SubscribeEvent
    public void onTerminalStorageScreenSize(TerminalStorageScreenSizeEvent event) {
        boolean isOpen = true;
        try {
            isOpen = ((IngredientListOverlay)jeiRuntime.getIngredientListOverlay()).isListDisplayed() || ((BookmarkOverlay)jeiRuntime.getBookmarkOverlay()).isListDisplayed();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        boolean wasJeiVisiblePrevious = this.wasJeiVisible;
        if (isOpen) {
            this.wasJeiVisible = true;
            event.setWidth(event.getWidth() - 180);
        } else {
            this.wasJeiVisible = false;
        }
        if (wasJeiVisiblePrevious != this.wasJeiVisible) {
            ((ContainerScreenTerminalStorage)Minecraft.m_91087_().f_91080_).m_7856_();
        }
    }

    protected boolean isSearchSynced(ITerminalStorageTabClient<?> clientTab) {
        for (ITerminalButton<?, ?, ?> button : clientTab.getButtons()) {
            if (!(button instanceof TerminalButtonItemStackCraftingGridJeiSearchSync)) continue;
            return ((TerminalButtonItemStackCraftingGridJeiSearchSync)button).isActive();
        }
        return false;
    }

    @SubscribeEvent
    public void onSearchFieldUpdated(TerminalStorageTabClientSearchFieldUpdateEvent event) {
        if (this.isSearchSynced(event.getClientTab())) {
            jeiRuntime.getIngredientFilter().setFilterText(event.getSearchString());
        }
    }

    @SubscribeEvent
    public void onKeyTyped(ScreenEvent.KeyboardKeyReleasedEvent.Post event) {
        if (event.getScreen() instanceof ContainerScreenTerminalStorage) {
            ContainerScreenTerminalStorage gui = (ContainerScreenTerminalStorage)event.getScreen();
            if (jeiRuntime.getIngredientListOverlay().hasKeyboardFocus()) {
                gui.getSelectedClientTab().ifPresent(tab -> {
                    if (this.isSearchSynced((ITerminalStorageTabClient<?>)tab)) {
                        WidgetTextFieldExtended fieldSearch = gui.getFieldSearch();
                        fieldSearch.m_94144_(jeiRuntime.getIngredientFilter().getFilterText());
                        tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)gui.getMenu()))).getSelectedChannel(), fieldSearch.m_94155_());
                    }
                });
            }
        }
    }
}

