/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.ingredient.storage.IngredientComponentStorageWrapperHandlerItemStack;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionHelpers;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminalscompat.IntegratedTerminalsCompat;
import org.cyclops.integratedterminalscompat.modcompat.jei.JEIIntegratedTerminalsConfig;
import org.cyclops.integratedterminalscompat.network.packet.TerminalStorageIngredientItemStackCraftingGridSetRecipe;

public class TerminalStorageRecipeTransferHandler<T extends ContainerTerminalStorageBase<?>>
implements IRecipeTransferHandler<T, CraftingRecipe> {
    private final IRecipeTransferHandlerHelper recipeTransferHandlerHelper;
    private final Class<T> clazz;

    public TerminalStorageRecipeTransferHandler(IRecipeTransferHandlerHelper recipeTransferHandlerHelper, Class<T> clazz) {
        this.recipeTransferHandlerHelper = recipeTransferHandlerHelper;
        this.clazz = clazz;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Class<CraftingRecipe> getRecipeClass() {
        return CraftingRecipe.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ContainerTerminalStorageBase container, CraftingRecipe recipe, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        if (Objects.equals(container.getSelectedTab(), TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
            ITerminalStorageTabCommon tabCommon = container.getTabCommon(container.getSelectedTab());
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
            if (!doTransfer) {
                IngredientCollectionPrototypeMap hayStackCraftingGrid = new IngredientCollectionPrototypeMap(IngredientComponent.ITEMSTACK);
                for (int slot = 0; slot < tabCommonCrafting.getInventoryCrafting().m_6643_(); ++slot) {
                    hayStackCraftingGrid.add((Object)tabCommonCrafting.getInventoryCrafting().m_8020_(slot));
                }
                IngredientCollectionPrototypeMap hayStackPlayer = new IngredientCollectionPrototypeMap(IngredientComponent.ITEMSTACK);
                hayStackPlayer.addAll((Iterable)player.m_150109_().f_35974_);
                TerminalStorageTabIngredientComponentClient tabClient = (TerminalStorageTabIngredientComponentClient)container.getTabClient(container.getSelectedTab());
                List unfilteredIngredients = tabClient.getUnfilteredIngredientsView(container.getSelectedChannel());
                IIngredientCollapsedCollectionMutable hayStack = IngredientCollectionHelpers.createCollapsedCollection((IngredientComponent)IngredientComponent.ITEMSTACK);
                hayStack.addAll((Iterable)unfilteredIngredients.stream().filter(i -> i.getCraftingOption() == null).map(TerminalStorageTabIngredientComponentClient.InstanceWithMetadata::getInstance).collect(Collectors.toList()));
                ArrayList slotsMissingItems = Lists.newArrayList();
                for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
                    IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
                    if (ingredient == null || !ingredient.isInput()) continue;
                    int slot = (Integer)entry.getKey();
                    if (ingredient.getAllIngredients().isEmpty()) continue;
                    boolean found = false;
                    for (ItemStack itemStack2 : ingredient.getAllIngredients()) {
                        int matchCondition;
                        if (hayStackCraftingGrid.contains((Object)itemStack2, (Object)(matchCondition = JEIIntegratedTerminalsConfig.getItemStackMatchCondition(itemStack2)))) {
                            hayStackPlayer.remove((Object)itemStack2);
                            found = true;
                            break;
                        }
                        if (hayStackPlayer.contains((Object)itemStack2, (Object)matchCondition)) {
                            hayStackPlayer.remove((Object)itemStack2);
                            found = true;
                            break;
                        }
                        if (!hayStack.contains((Object)itemStack2, (Object)matchCondition)) continue;
                        hayStack.remove((Object)itemStack2);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    slotsMissingItems.add(slot);
                }
                if (!slotsMissingItems.isEmpty()) {
                    TranslatableComponent message = new TranslatableComponent("jei.tooltip.error.recipe.transfer.missing");
                    return this.recipeTransferHandlerHelper.createUserErrorForSlots((Component)message, (Collection)slotsMissingItems);
                }
                return null;
            }
            IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper playerInventory = new IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper(IngredientComponent.ITEMSTACK, (IItemHandler)new InvWrapper((Container)player.m_150109_()));
            HashMap slottedIngredientsFromPlayer = Maps.newHashMap();
            HashMap slottedIngredientsFromStorage = Maps.newHashMap();
            int slotOffset = tabCommonCrafting.getSlotCrafting().f_40219_;
            for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
                IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
                if (ingredient == null || !ingredient.isInput()) continue;
                int slotId = (Integer)entry.getKey();
                boolean found = false;
                for (ItemStack itemStack3 : ingredient.getAllIngredients()) {
                    int matchCondition;
                    if (playerInventory.extract(itemStack3, Integer.valueOf(matchCondition = JEIIntegratedTerminalsConfig.getItemStackMatchCondition(itemStack3)), true).m_41619_()) continue;
                    found = true;
                    ItemStack extracted = playerInventory.extract(itemStack3, Integer.valueOf(matchCondition), false);
                    Slot slot = container.m_38853_(slotId + slotOffset);
                    slot.m_5852_(extracted);
                    slottedIngredientsFromPlayer.put(slotId, Pair.of((Object)itemStack3, (Object)JEIIntegratedTerminalsConfig.getItemStackMatchCondition(itemStack3)));
                    break;
                }
                if (found) continue;
                slottedIngredientsFromStorage.put(slotId, ingredient.getAllIngredients().stream().map(itemStack -> Pair.of((Object)itemStack, (Object)JEIIntegratedTerminalsConfig.getItemStackMatchCondition(itemStack))).collect(Collectors.toList()));
            }
            IntegratedTerminalsCompat._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetRecipe(container.getSelectedTab(), container.getSelectedChannel(), maxTransfer, slottedIngredientsFromPlayer, slottedIngredientsFromStorage));
            return null;
        }
        return new TransferError();
    }

    public static class TransferError
    implements IRecipeTransferError {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }

        public void showError(PoseStack matrixStack, int i, int i1, IRecipeLayout iRecipeLayout, int i2, int i3) {
        }
    }
}

