/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder;

import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpawnProtectionEvents {
    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        if (SpawnProtectionEvents.isOnSpawn((Entity)event.getPlayer()) && !event.getPlayer().m_20310_(2) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void mobGrief(EntityMobGriefingEvent event) {
        if (event.getEntity() != null && event.getEntity().f_19853_ != null && event.getEntity().f_19853_.m_46472_() != null && SpawnProtectionEvents.isOnSpawn(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void explode(ExplosionEvent.Start event) {
        if (SpawnProtectionEvents.isOnSpawn(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (SpawnProtectionEvents.isOnSpawn((Entity)event.getPlayer()) && !event.getPlayer().m_20310_(2)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockPlace(BlockEvent.EntityPlaceEvent event) {
        Level level;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof Level && SpawnProtectionEvents.isOnSpawn(level = (Level)levelAccessor, event.getPos()) && (!(event.getEntity() instanceof Player) || !event.getEntity().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockMultiPlace(BlockEvent.EntityMultiPlaceEvent event) {
        Level level;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof Level && SpawnProtectionEvents.isOnSpawn(level = (Level)levelAccessor, event.getPos()) && (!(event.getEntity() instanceof Player) || !event.getEntity().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void farmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (SpawnProtectionEvents.isOnSpawn(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.CropGrowEvent.Pre event) {
        Level level;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof Level && SpawnProtectionEvents.isOnSpawn(level = (Level)levelAccessor, event.getPos())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.BlockToolInteractEvent event) {
        if (SpawnProtectionEvents.isOnSpawn((Entity)event.getPlayer()) && !event.getPlayer().m_20310_(2)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void mobSpawnAttempt(LivingSpawnEvent.CheckSpawn event) {
        Level level = event.getWorld() instanceof Level ? (Level)event.getWorld() : event.getEntity().f_19853_;
        if (level != null && SpawnProtectionEvents.isOnSpawn(event.getEntity()) && !(event.getEntity() instanceof Player)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void mobSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Level level = event.getWorld() instanceof Level ? (Level)event.getWorld() : event.getEntity().f_19853_;
        if (level != null && SpawnProtectionEvents.isOnSpawn(event.getEntity()) && !(event.getEntity() instanceof Player) && event.getSpawnReason() != MobSpawnType.SPAWN_EGG && event.getSpawnReason() != MobSpawnType.BUCKET && event.getSpawnReason() != MobSpawnType.MOB_SUMMONED && event.getSpawnReason() != MobSpawnType.COMMAND && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        if (!(event.getSource().m_19378_() || !SpawnProtectionEvents.isOnSpawn(event.getEntity()) || event.getSource().m_7639_() instanceof Player && event.getSource().m_7639_().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        if (!(event.getSource().m_19378_() || !SpawnProtectionEvents.isOnSpawn(event.getEntity()) || !(event.getEntity() instanceof Player) && event.getSource().m_7639_() instanceof Player && event.getSource().m_7639_().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.f_19853_.f_46443_ && !event.player.m_21224_() && event.player.f_19797_ % 20 == 0 && SpawnProtectionEvents.isOnSpawn((Entity)event.player)) {
            event.player.m_21153_(20.0f);
            event.player.m_36324_().m_38705_(20);
            event.player.m_20301_(event.player.m_6062_());
            event.player.m_7311_(0);
        }
    }

    private static boolean isOnSpawn(Level level, BlockPos blockPos) {
        ChunkPos pos = new ChunkPos(blockPos);
        return WorldUtil.isSkyblock(level) && ConfigHandler.Spawn.dimension == level.m_46472_() && Math.abs(pos.f_45578_) < ConfigHandler.Spawn.spawnProtectionRadius && Math.abs(pos.f_45579_) < ConfigHandler.Spawn.spawnProtectionRadius;
    }

    private static boolean isOnSpawn(Entity entity) {
        ChunkPos pos = new ChunkPos(entity.m_142538_());
        return WorldUtil.isSkyblock(entity.f_19853_) && ConfigHandler.Spawn.dimension == entity.f_19853_.m_46472_() && Math.abs(pos.f_45578_) < ConfigHandler.Spawn.spawnProtectionRadius && Math.abs(pos.f_45579_) < ConfigHandler.Spawn.spawnProtectionRadius;
    }
}

