/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.api;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.chat.TranslatableComponent;

public class SkyblockBuilderAPI {
    private static final List<String> teamManagementDisablingMods = new ArrayList<String>();
    private static boolean spawnTeleportEnabled = true;

    public static void disableAllTeamManagement(String modid) {
        teamManagementDisablingMods.add(modid);
        teamManagementDisablingMods.sort(Comparator.naturalOrder());
        SkyblockBuilder.getLogger().warn(modid + " disabled all team management features.");
    }

    public static void disableSpawnTeleport(String modid) {
        spawnTeleportEnabled = false;
        SkyblockBuilder.getLogger().warn(modid + " disabled teleporting to spawn on world join.");
    }

    public static void checkTeamManagement() throws CommandSyntaxException {
        if (!teamManagementDisablingMods.isEmpty()) {
            throw new SimpleCommandExceptionType((Message)new TranslatableComponent("skyblockbuilder.compat.disabled_management", new Object[]{String.join((CharSequence)", ", teamManagementDisablingMods)})).create();
        }
    }

    public static boolean teamManagementEnabled() {
        return teamManagementDisablingMods.isEmpty();
    }

    public static boolean isSpawnTeleportEnabled() {
        return spawnTeleportEnabled;
    }
}

