/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyblockbuilder.Registration;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class ScreenCustomizeSkyblock
extends Screen {
    private final Screen parent;
    private final List<ConfiguredTemplate> templateMap;
    private final Consumer<ConfiguredTemplate> applyTemplate;
    private TemplateList list;
    private Button doneButton;
    private ConfiguredTemplate template;

    public ScreenCustomizeSkyblock(Screen parent) {
        super(Registration.skyblock.getDisplayName());
        this.parent = parent;
        TemplateLoader.updateTemplates();
        this.template = TemplateLoader.getConfiguredTemplate();
        this.templateMap = TemplateLoader.getConfiguredTemplates();
        this.applyTemplate = TemplateLoader::setTemplate;
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.list = new TemplateList();
        this.m_7787_((GuiEventListener)this.list);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 28, 150, 20, CommonComponents.f_130655_, button -> {
            this.applyTemplate.accept(this.template);
            this.f_96541_.m_91152_(this.parent);
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 28, 150, 20, CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(this.parent)));
        if (this.template != null) {
            this.list.setSelected(this.list.m_6702_().stream().filter(entry -> Objects.equals(entry.template.getTemplate(), this.template.getTemplate())).findFirst().orElse(null));
        }
    }

    private void updateButtonValidity() {
        this.doneButton.f_93623_ = this.list.m_93511_() != null;
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_96626_(0);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTick);
        Screen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)8, (int)Color.WHITE.getRGB());
        Screen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("screen.skyblockbuilder.select_template"), (int)(this.f_96543_ / 2), (int)28, (int)Color.GRAY.getRGB());
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.list.renderEntries(poseStack, mouseX, mouseY, partialTick);
    }

    private class TemplateList
    extends ObjectSelectionList<TemplateEntry> {
        private static final ResourceLocation ICON_MISSING = new ResourceLocation("minecraft", "textures/misc/unknown_server.png");

        public TemplateList() {
            super(Objects.requireNonNull(ScreenCustomizeSkyblock.this.f_96541_), ScreenCustomizeSkyblock.this.f_96543_, ScreenCustomizeSkyblock.this.f_96544_, 40, ScreenCustomizeSkyblock.this.f_96544_ - 37, 40);
            ScreenCustomizeSkyblock.this.templateMap.stream().sorted(Comparator.comparing(ConfiguredTemplate::getName)).forEach(entry -> this.m_7085_((AbstractSelectionList.Entry)new TemplateEntry((ConfiguredTemplate)entry)));
        }

        protected boolean m_5694_() {
            return ScreenCustomizeSkyblock.this.m_7222_() == this;
        }

        public void setSelected(@Nullable TemplateEntry entry) {
            super.m_6987_((AbstractSelectionList.Entry)entry);
            if (entry != null) {
                ScreenCustomizeSkyblock.this.template = entry.template;
            }
            ScreenCustomizeSkyblock.this.updateButtonValidity();
        }

        public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTick);
            if (this.m_93511_() != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)(((TemplateEntry)this.m_93511_()).icon != null ? ((TemplateEntry)this.m_93511_()).iconLocation : ICON_MISSING));
                RenderSystem.m_69478_();
                int size = (this.f_93388_ - 220) / 2 - 40;
                int iconSize = ((TemplateEntry)this.m_93511_()).icon != null ? ((TemplateEntry)this.m_93511_()).icon.m_117991_().m_85084_() : 16;
                GuiComponent.m_93160_((PoseStack)poseStack, (int)20, (int)85, (int)size, (int)size, (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (int)iconSize, (int)iconSize);
                RenderSystem.m_69461_();
            }
        }

        protected void m_93451_(@Nonnull PoseStack poseStack, int x, int y, int mouseX, int mouseY, float partialTick) {
        }

        protected void renderEntries(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.m_93451_(poseStack, this.m_5747_(), this.f_93390_ + 4 - (int)this.m_93517_(), mouseX, mouseY, partialTick);
        }

        private class TemplateEntry
        extends ObjectSelectionList.Entry<TemplateEntry> {
            private final Component name;
            private final Component desc;
            private final ConfiguredTemplate template;
            private final boolean tooLong;
            private final ResourceLocation iconLocation;
            private File iconFile;
            private final DynamicTexture icon;

            public TemplateEntry(ConfiguredTemplate template) {
                this.name = template.getNameComponent();
                this.desc = this.shortened(template.getDescriptionComponent());
                this.template = template;
                this.tooLong = !this.desc.getString().equals(template.getDescriptionComponent().getString());
                this.iconLocation = SkyblockBuilder.getInstance().resource(Util.m_137483_((String)template.getName(), ResourceLocation::m_135828_) + "/icon");
                this.iconFile = SkyPaths.ICONS_DIR.resolve(template.getName().toLowerCase(Locale.ROOT) + ".png").toFile();
                if (!this.iconFile.isFile()) {
                    SkyblockBuilder.getLogger().info("No icon set for template '" + template.getName() + "'. Should be at this location: '" + this.iconFile + "'");
                    this.iconFile = null;
                }
                this.icon = this.loadIcon();
            }

            public void m_6311_(@Nonnull PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                GuiComponent.m_93243_((PoseStack)poseStack, (Font)ScreenCustomizeSkyblock.this.f_96547_, (Component)this.name, (int)(left + 5), (int)(top + 7), (int)Color.WHITE.getRGB());
                GuiComponent.m_93243_((PoseStack)poseStack, (Font)ScreenCustomizeSkyblock.this.f_96547_, (Component)this.desc, (int)(left + 5), (int)(top + 22), (int)Color.GRAY.getRGB());
                if (isMouseOver && this.tooLong) {
                    ScreenCustomizeSkyblock.this.m_96602_(poseStack, this.template.getDescriptionComponent(), mouseX, mouseY);
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    TemplateList.this.setSelected(this);
                    return true;
                }
                return false;
            }

            @Nonnull
            public Component m_142172_() {
                return this.name;
            }

            private DynamicTexture loadIcon() {
                if (this.iconFile != null && this.iconFile.isFile()) {
                    try {
                        DynamicTexture texture;
                        try (FileInputStream in = new FileInputStream(this.iconFile);){
                            NativeImage image = NativeImage.m_85058_((InputStream)in);
                            Validate.validState((image.m_84982_() == image.m_85084_() ? 1 : 0) != 0, (String)"Height and width must be equal.", (Object[])new Object[0]);
                            DynamicTexture tempTexture = new DynamicTexture(image);
                            Minecraft.m_91087_().f_90987_.m_118495_(this.iconLocation, (AbstractTexture)tempTexture);
                            texture = tempTexture;
                        }
                        return texture;
                    }
                    catch (Throwable throwable) {
                        SkyblockBuilder.getLogger().error("Invalid icon for template {}", (Object)this.template.getName(), (Object)throwable);
                        return null;
                    }
                }
                Minecraft.m_91087_().f_90987_.m_118513_(this.iconLocation);
                return null;
            }

            private Component shortened(Component text) {
                String string = text.getString();
                String shorten = RandomUtility.shorten(Minecraft.m_91087_().f_91062_, string, 210);
                return new TextComponent(shorten);
            }
        }
    }
}

