/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LeaveCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"leave").executes(context -> LeaveCommand.leaveTeam((CommandSourceStack)context.getSource()));
    }

    private static int leaveTeam(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        if (!data.hasPlayerTeam((Player)player)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        switch (SkyblockHooks.onLeave(player, data.getTeamFromPlayer((Player)player))) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.leave_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (ConfigHandler.Utility.selfManage || source.m_6761_(2)) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.manage_teams").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        if (ConfigHandler.Inventory.dropItems) {
            RandomUtility.dropInventories((Player)player);
        }
        data.removePlayerFromTeam((Player)player);
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.left_team").m_130940_(ChatFormatting.GOLD), true);
        WorldUtil.teleportToIsland(player, data.getSpawn());
        return 1;
    }
}

