/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SpawnCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").requires(source -> ConfigHandler.Utility.Teleports.spawn || source.m_6761_(2))).executes(context -> SpawnCommand.spawn((CommandSourceStack)context.getSource()));
    }

    private static int spawn(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getSpawn();
        if (!player.m_20310_(2) && !data.getOrCreateMetaInfo((Player)player).canTeleportSpawn(level.m_46467_())) {
            source.m_81352_((Component)new TranslatableComponent("skyblockbuilder.command.error.cooldown", new Object[]{RandomUtility.formattedCooldown((long)ConfigHandler.Utility.Teleports.spawnCooldown - (level.m_46467_() - data.getOrCreateMetaInfo((Player)player).getLastSpawnTeleport()))}));
            return 0;
        }
        if (!ConfigHandler.Utility.Teleports.teleportationDimensions.test(player.m_183503_().m_46472_().m_135782_())) {
            source.m_81352_((Component)new TranslatableComponent("skyblockbuilder.command.error.teleportation_not_allowed_dimension"));
            return 0;
        }
        if (!ConfigHandler.Utility.Teleports.crossDimensionTeleportation && player.m_183503_() != data.getLevel()) {
            source.m_81352_((Component)new TranslatableComponent("skyblockbuilder.command.error.teleport_across_dimensions"));
            return 0;
        }
        data.getOrCreateMetaInfo((Player)player).setLastSpawnTeleport(level.m_46467_());
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.teleport_to_spawn"), false);
        WorldUtil.teleportToIsland(player, team);
        return 1;
    }
}

