/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockJoinRequestEvent;
import de.melanx.skyblockbuilder.events.SkyblockManageTeamEvent;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class TeamCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawns").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").executes(context -> TeamCommand.addSpawn((CommandSourceStack)context.getSource(), new BlockPos(((CommandSourceStack)context.getSource()).m_81371_())))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> TeamCommand.addSpawn((CommandSourceStack)context.getSource(), BlockPosArgument.m_118242_((CommandContext)context, (String)"pos")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").executes(context -> TeamCommand.removeSpawn((CommandSourceStack)context.getSource(), new BlockPos(((CommandSourceStack)context.getSource()).m_81371_())))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).suggests(Suggestions.SPAWN_POSITIONS).executes(context -> TeamCommand.removeSpawn((CommandSourceStack)context.getSource(), BlockPosArgument.m_118242_((CommandContext)context, (String)"pos")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").executes(context -> TeamCommand.resetSpawns((CommandSourceStack)context.getSource(), null))).then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> TeamCommand.resetSpawns((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))))))).then(Commands.m_82127_((String)"rename").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> TeamCommand.renameTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), null))).then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> TeamCommand.renameTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"team"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"allowVisit").executes(context -> TeamCommand.showVisitInformation((CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.toggleAllowVisit((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"enabled")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"allowRequests").executes(context -> TeamCommand.showRequestInformation((CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.toggleAllowRequest((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"enabled")))))).then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).suggests(Suggestions.INVITED_PLAYERS_OF_PLAYERS_TEAM).executes(context -> TeamCommand.acceptRequest((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"deny").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).suggests(Suggestions.INVITED_PLAYERS_OF_PLAYERS_TEAM).executes(context -> TeamCommand.denyRequest((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
    }

    private static int acceptRequest(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer commandPlayer = source.m_81375_();
        Team team = data.getTeamFromPlayer((Player)commandPlayer);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (data.hasPlayerTeam((Player)player)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.player_has_team"), false);
            team.removeJoinRequest((Player)player);
            return 0;
        }
        SkyblockJoinRequestEvent.AcceptRequest event = SkyblockHooks.onAcceptJoinRequest(commandPlayer, player, team);
        switch (event.getResult()) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.accept_join_request").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (ConfigHandler.Utility.selfManage || source.m_6761_(2)) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.accept_join_request").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        team.broadcast((MutableComponent)new TranslatableComponent("skyblockbuilder.event.accept_join_request", new Object[]{commandPlayer.m_5446_(), player.m_5446_()}), Style.f_131099_.m_131157_(ChatFormatting.GOLD));
        data.addPlayerToTeam(team, (Player)player);
        team.removeJoinRequest((Player)player);
        WorldUtil.teleportToIsland(player, team);
        player.m_5661_((Component)new TranslatableComponent("skyblockbuilder.command.success.join_request_accepted", new Object[]{team.getName()}).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int denyRequest(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer commandPlayer = source.m_81375_();
        Team team = data.getTeamFromPlayer((Player)commandPlayer);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (data.hasPlayerTeam((Player)player)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.player_has_team"), false);
            team.removeJoinRequest((Player)player);
            return 0;
        }
        SkyblockJoinRequestEvent.DenyRequest event = SkyblockHooks.onDenyJoinRequest(commandPlayer, player, team);
        switch (event.getResult()) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.deny_join_request").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (ConfigHandler.Utility.selfManage || source.m_6761_(2)) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.deny_join_request").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        team.broadcast((MutableComponent)new TranslatableComponent("skyblockbuilder.event.deny_join_request", new Object[]{commandPlayer.m_5446_(), player.m_5446_()}), Style.f_131099_.m_131157_(ChatFormatting.GOLD));
        team.removeJoinRequest((Player)player);
        player.m_5661_((Component)new TranslatableComponent("skyblockbuilder.command.success.deny_request_accepted", new Object[]{team.getName()}).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int showVisitInformation(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)source.m_81375_());
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        boolean enabled = team.allowsVisits();
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.info.visit_status", new Object[]{new TranslatableComponent("skyblockbuilder.command.argument." + (enabled ? "enabled" : "disabled"))}).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int toggleAllowVisit(CommandSourceStack source, boolean enabled) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        Pair<Event.Result, Boolean> result = SkyblockHooks.onToggleVisits(player, team, enabled);
        if (result.getLeft() == Event.Result.DENY) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.toggle_request", new Object[]{new TranslatableComponent("skyblockbuilder.command.argument." + (enabled ? "enable" : "disable"))}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        team.setAllowVisit((Boolean)result.getRight());
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.info.toggle_visit", new Object[]{new TranslatableComponent("skyblockbuilder.command.argument." + (enabled ? "enabled" : "disabled"))}).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int showRequestInformation(CommandSourceStack source) throws CommandSyntaxException {
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)source.m_81375_());
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        boolean enabled = team.allowsVisits();
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.info.visit_status", new Object[]{new TranslatableComponent("skyblockbuilder.command.argument." + (enabled ? "enabled" : "disabled"))}).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int toggleAllowRequest(CommandSourceStack source, boolean enabled) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        Pair<Event.Result, Boolean> result = SkyblockHooks.onToggleRequests(player, team, enabled);
        if (result.getLeft() == Event.Result.DENY) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.toggle_request", new Object[]{new TranslatableComponent("skyblockbuilder.command.argument." + (enabled ? "enable" : "disable"))}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        team.setAllowJoinRequest((Boolean)result.getRight());
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.info.toggle_request", new Object[]{new TranslatableComponent("skyblockbuilder.command.argument." + (enabled ? "enabled" : "disabled"))}).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int addSpawn(CommandSourceStack source, BlockPos pos) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (level != source.m_81377_().m_129880_(ConfigHandler.Spawn.dimension)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.wrong_position").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            if (!source.m_6761_(2)) {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.warning.edit_spawn_spawns").m_130940_(ChatFormatting.RED), false);
            team = data.getSpawn();
        }
        Pair<Event.Result, BlockPos> result = SkyblockHooks.onAddSpawn(player, team, pos);
        switch ((Event.Result)result.getLeft()) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.create_spawn").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (!(ConfigHandler.Utility.selfManage && ConfigHandler.Utility.Spawns.modifySpawns || source.m_6761_(2))) {
                    source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.modify_spawns").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                Vec3i templateSize = TemplateData.get(level).getConfiguredTemplate().getTemplate().m_163801_();
                BlockPos.MutableBlockPos center = team.getIsland().getCenter().m_122032_();
                center.m_142082_(templateSize.m_123341_() / 2, templateSize.m_123342_() / 2, templateSize.m_123343_() / 2);
                if (pos.m_123314_((Vec3i)center, (double)ConfigHandler.Utility.Spawns.range)) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.position_too_far_away").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        team.addPossibleSpawn(pos);
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.spawn_added", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int removeSpawn(CommandSourceStack source, BlockPos pos) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (level != source.m_81377_().m_129880_(ConfigHandler.Spawn.dimension)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.wrong_position").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        switch (SkyblockHooks.onRemoveSpawn(player, team, pos)) {
            case DENY: {
                TranslatableComponent component = new TranslatableComponent("skyblockbuilder.command.denied.modify_spawns0");
                if (team.getPossibleSpawns().size() <= 1) {
                    component.m_130946_(" ").m_7220_((Component)new TranslatableComponent("skyblockbuilder.command.denied.modify_spawns1"));
                }
                source.m_81354_((Component)component.m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (ConfigHandler.Utility.selfManage && ConfigHandler.Utility.Spawns.modifySpawns || source.m_6761_(2)) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.modify_spawns").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        if (!team.removePossibleSpawn(pos)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.remove_spawn0", new Object[]{team.getPossibleSpawns().size() <= 1 ? new TextComponent(" ").m_7220_((Component)new TranslatableComponent("skyblockbuilder.command.error.remove_spawn1")) : ""}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.spawn_removed", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int resetSpawns(CommandSourceStack source, String name) throws CommandSyntaxException {
        Team team;
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = null;
        if (name == null) {
            if (!(source.m_81373_() instanceof ServerPlayer)) {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_no_player").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            player = (ServerPlayer)source.m_81373_();
            team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        } else {
            team = data.getTeam(name);
            if (team == null) {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        Event.Result result = SkyblockHooks.onResetSpawns(player, team);
        switch (result) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.reset_spawns").m_130940_(ChatFormatting.GOLD), false);
                return 0;
            }
            case DEFAULT: {
                if (ConfigHandler.Utility.selfManage && ConfigHandler.Utility.Spawns.modifySpawns || source.m_6761_(2)) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.modify_spawns").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        team.setPossibleSpawns(team.getPossibleSpawns());
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.reset_spawns").m_130940_(ChatFormatting.GOLD), true);
        return 1;
    }

    private static int renameTeam(CommandSourceStack source, String newName, String oldName) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (oldName != null) {
            Team team = data.getTeam(oldName);
            if (team == null) {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            SkyblockManageTeamEvent.Rename event = SkyblockHooks.onRename(null, team, newName);
            switch (event.getResult()) {
                case DENY: {
                    source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.denied_rename_team").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                case DEFAULT: {
                    if (source.m_6761_(2)) break;
                    source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.rename_team").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
            }
            data.renameTeam(team, event.getPlayer(), event.getNewName());
        } else {
            ServerPlayer player = source.m_81375_();
            Team team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            SkyblockManageTeamEvent.Rename event = SkyblockHooks.onRename(player, team, newName);
            switch (event.getResult()) {
                case DENY: {
                    source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.denied_rename_team").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
            }
            data.renameTeam(team, event.getPlayer(), event.getNewName());
        }
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.rename_team", new Object[]{newName}).m_130940_(ChatFormatting.GOLD), true);
        return 1;
    }
}

