/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VisitCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"visit").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.VISIT_TEAMS).executes(context -> VisitCommand.visit((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int visit(CommandSourceStack source, String name) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeam(name);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (!ConfigHandler.Utility.Teleports.teleportationDimensions.test(player.m_183503_().m_46472_().m_135782_())) {
            source.m_81352_((Component)new TranslatableComponent("skyblockbuilder.command.error.teleportation_not_allowed_dimension"));
            return 0;
        }
        if (!ConfigHandler.Utility.Teleports.crossDimensionTeleportation && player.m_183503_() != data.getLevel()) {
            source.m_81352_((Component)new TranslatableComponent("skyblockbuilder.command.error.teleport_across_dimensions"));
            return 0;
        }
        switch (SkyblockHooks.onVisit(player, team)) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.visit_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (team.hasPlayer((Player)player)) {
                    source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.visit_own_team").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                if (player.m_20310_(2)) break;
                if (!ConfigHandler.Utility.Teleports.allowVisits) {
                    source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.team_visit").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                if (team.allowsVisits()) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.visit_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        WorldUtil.teleportToIsland(player, team);
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.visit_team", new Object[]{name}).m_130940_(ChatFormatting.GOLD), true);
        return 1;
    }
}

