/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.StartingInventory;
import de.melanx.skyblockbuilder.util.RandomUtility;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class InventoryCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"inventory").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(source -> source.m_6761_(2))).executes(context -> InventoryCommand.exportInventory((CommandSourceStack)context.getSource())));
    }

    private static int exportInventory(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        String folderName = "skyblock_exports";
        try {
            Files.createDirectories(Paths.get(folderName, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SimpleCommandExceptionType((Message)new TranslatableComponent("skyblockbuilder.command.error.creating_path", new Object[]{folderName})).create();
        }
        String filePath = RandomUtility.getFilePath(folderName, "starter_item", "json");
        JsonObject json = new JsonObject();
        JsonArray items = new JsonArray();
        Inventory inventory = player.m_150109_();
        for (ItemStack stack : inventory.f_35974_) {
            if (stack.m_41619_()) continue;
            items.add((JsonElement)StartingInventory.serializeItem(stack));
        }
        for (ItemStack stack : inventory.f_35976_) {
            if (stack.m_41619_()) continue;
            items.add((JsonElement)StartingInventory.serializeItem(stack, EquipmentSlot.OFFHAND));
        }
        for (Object slot : (Object)Inventory.f_150068_) {
            ItemStack stack = (ItemStack)inventory.f_35975_.get((int)slot);
            if (stack.m_41619_()) continue;
            EquipmentSlot equipmentSlot = switch (slot) {
                case 0 -> EquipmentSlot.FEET;
                case 1 -> EquipmentSlot.LEGS;
                case 2 -> EquipmentSlot.CHEST;
                case 3 -> EquipmentSlot.HEAD;
                default -> EquipmentSlot.MAINHAND;
            };
            items.add((JsonElement)StartingInventory.serializeItem(stack, equipmentSlot));
        }
        json.add("items", (JsonElement)items);
        Path file = Paths.get(folderName, new String[0]).resolve(filePath.split("/")[1]);
        try {
            BufferedWriter w = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            w.write(SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)json));
            w.close();
        }
        catch (IOException e) {
            throw new SimpleCommandExceptionType((Message)new TranslatableComponent("skyblockbuilder.command.error.creating_file", new Object[]{file})).create();
        }
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.export_inventory", new Object[]{filePath}).m_130940_(ChatFormatting.GOLD), true);
        return 1;
    }
}

