/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;

public class ListCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(context -> ListCommand.listTeams((CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ListCommand.listPlayers((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int listTeams(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        List teams = data.getTeams().stream().sorted(Comparator.comparing(Team::getName)).filter(team -> !team.getName().equalsIgnoreCase("spawn")).collect(Collectors.toList());
        TranslatableComponent info = new TranslatableComponent("skyblockbuilder.command.info.teams", new Object[]{teams.size(), teams.stream().filter(Team::isEmpty).count()});
        info.m_130940_(ChatFormatting.GOLD);
        source.m_81354_((Component)info, false);
        for (Team team2 : teams) {
            if (team2.isSpawn()) continue;
            TextComponent list = new TextComponent("- " + team2.getName());
            if (team2.isEmpty()) {
                list.m_130946_(" (");
                list.m_7220_((Component)new TranslatableComponent("skyblockbuilder.command.argument.empty"));
                list.m_130946_(")");
                list.m_130940_(ChatFormatting.RED);
            } else {
                list.m_130940_(ChatFormatting.GREEN);
            }
            source.m_81354_((Component)list, false);
        }
        return 1;
    }

    private static int listPlayers(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeam(teamName);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        GameProfileCache profileCache = source.m_81377_().m_129927_();
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.info.team_detailed", new Object[]{team.getName(), team.getPlayers().size()}).m_130940_(ChatFormatting.GOLD), false);
        team.getPlayers().forEach(id -> {
            String name;
            Optional profile = profileCache.m_11002_(id);
            if (profile.isPresent() && !StringUtil.m_14408_((String)(name = ((GameProfile)profile.get()).getName()))) {
                source.m_81354_((Component)new TextComponent("- " + name), false);
            }
        });
        return 1;
    }
}

