/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import io.github.noeppi_noeppi.libx.command.EnumArgument2;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SpawnsCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"spawns").executes(context -> SpawnsCommand.showSpawns((CommandSourceStack)context.getSource(), Mode.NORMAL))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mode", (ArgumentType)EnumArgument2.enumArgument(Mode.class)).requires(source -> source.m_6761_(2))).executes(context -> SpawnsCommand.showSpawns((CommandSourceStack)context.getSource(), (Mode)((Object)((Object)context.getArgument("mode", Mode.class))))));
    }

    private static int showSpawns(CommandSourceStack source, Mode mode) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (mode == Mode.EXPORT) {
            Team team = null;
            if (source.m_81373_() instanceof ServerPlayer) {
                team = data.getTeamFromPlayer((Player)source.m_81373_());
            }
            if (team == null) {
                team = data.getSpawn();
            }
            String folderName = "skyblock_exports";
            try {
                Files.createDirectories(Paths.get(folderName, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SimpleCommandExceptionType((Message)new TranslatableComponent("skyblockbuilder.command.error.creating_path", new Object[]{folderName})).create();
            }
            String filePath = RandomUtility.getFilePath(folderName, "spawns", "json");
            JsonObject json = new JsonObject();
            JsonArray spawns = new JsonArray();
            Set<BlockPos> possibleSpawns = team.getPossibleSpawns();
            for (BlockPos pos : possibleSpawns) {
                JsonArray arr = new JsonArray();
                arr.add((Number)(pos.m_123341_() % ConfigHandler.World.islandDistance));
                arr.add((Number)(pos.m_123342_() - team.getIsland().getCenter().m_123342_()));
                arr.add((Number)(pos.m_123343_() % ConfigHandler.World.islandDistance));
                spawns.add((JsonElement)arr);
            }
            json.add("islandSpawns", (JsonElement)spawns);
            Path file = Paths.get(folderName, new String[0]).resolve(filePath.split("/")[1]);
            try {
                BufferedWriter w = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                w.write(SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)json));
                w.close();
            }
            catch (IOException e) {
                throw new SimpleCommandExceptionType((Message)new TranslatableComponent("skyblockbuilder.command.error.creating_file", new Object[]{file})).create();
            }
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.export_spawns", new Object[]{filePath}).m_130940_(ChatFormatting.GOLD), true);
            return 1;
        }
        for (Team team : data.getTeams()) {
            Set<BlockPos> posSet = mode == Mode.NORMAL ? team.getDefaultPossibleSpawns() : team.getPossibleSpawns();
            for (BlockPos pos : posSet) {
                if (source.m_81373_() instanceof ServerPlayer) {
                    level.m_8624_(source.m_81375_(), (ParticleOptions)ParticleTypes.f_123748_, true, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.1, 0.1, 0.1, 10.0);
                    continue;
                }
                level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.1, 0.1, 0.1, 10.0);
            }
        }
        return 1;
    }

    public static enum Mode {
        NORMAL,
        DEBUG,
        EXPORT;

    }
}

