/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.invitation;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AcceptCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.INVITE_TEAMS).executes(context -> AcceptCommand.acceptTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int acceptTeam(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeam(teamName);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (data.hasPlayerTeam((Player)player)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (!data.hasInvites((Player)player)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.no_invitations").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        switch (SkyblockHooks.onAccept(player, team)) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.accept_invitations").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (ConfigHandler.Utility.selfManage || source.m_6761_(2)) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.accept_invitations").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        if (!data.acceptInvite(team, (Player)player)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.accept_invitations").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.joined_team", new Object[]{team.getName()}).m_130940_(ChatFormatting.GOLD), true);
        return 1;
    }
}

