/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.invitation;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockInvitationEvent;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class InviteCommand {
    public static HoverEvent COPY_TEXT = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("skyblockbuilder.command.info.click_to_copy"));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> InviteCommand.invitePlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"))));
    }

    private static int invitePlayer(CommandSourceStack source, ServerPlayer invitePlayer) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        Team invitedPlayersTeam = data.getTeamFromPlayer((Player)invitePlayer);
        if (invitedPlayersTeam != null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.player_has_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (data.hasInviteFrom(team, (Player)invitePlayer)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.player_already_invited").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        SkyblockInvitationEvent.Invite event = SkyblockHooks.onInvite(invitePlayer, team, player);
        switch (event.getResult()) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.invite_player").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (ConfigHandler.Utility.selfManage || source.m_6761_(2)) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.send_invitations").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        data.addInvite(team, (Player)event.getInvitor(), (Player)invitePlayer);
        MutableComponent invite = new TranslatableComponent("skyblockbuilder.command.info.invited_to_team0", new Object[]{player.m_5446_().getString(), team.getName()}).m_130940_(ChatFormatting.GOLD);
        invite.m_7220_((Component)new TextComponent("/skyblock accept \"" + team.getName() + "\"").m_6270_(Style.f_131099_.m_131144_(COPY_TEXT).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/skyblock accept \"" + team.getName() + "\"")).m_131157_(ChatFormatting.UNDERLINE).m_131157_(ChatFormatting.GOLD)));
        invite.m_7220_((Component)new TranslatableComponent("skyblockbuilder.command.info.invited_to_team1").m_130940_(ChatFormatting.GOLD));
        invitePlayer.m_5661_((Component)invite, false);
        return 1;
    }
}

