/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.invitation;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockJoinRequestEvent;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class JoinCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"join").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> JoinCommand.sendJoinRequest((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int sendJoinRequest(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeam(teamName);
        if (team == null) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (data.hasPlayerTeam((Player)player)) {
            source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        SkyblockJoinRequestEvent.SendRequest event = SkyblockHooks.onSendJoinRequest(player, team);
        switch (event.getResult()) {
            case DENY: {
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.denied.join_request").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (source.m_6761_(2)) break;
                if (!ConfigHandler.Utility.selfManage) {
                    source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.join_request").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                if (team.allowsJoinRequests()) break;
                source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.disabled.team_join_request").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        team.sendJoinRequest((Player)player);
        source.m_81354_((Component)new TranslatableComponent("skyblockbuilder.command.success.join_request", new Object[]{teamName}).m_130940_(ChatFormatting.GOLD), true);
        return 1;
    }
}

