/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config;

import com.google.common.collect.Maps;
import de.melanx.skyblockbuilder.config.SpawnSettings;
import io.github.noeppi_noeppi.libx.config.Config;
import io.github.noeppi_noeppi.libx.config.Group;
import io.github.noeppi_noeppi.libx.config.validator.IntRange;
import io.github.noeppi_noeppi.libx.util.ResourceList;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ConfigHandler {

    public static class Utility {
        @Config(value={"Should players be able to leave their team or invite others? [default: true]"})
        public static boolean selfManage = true;
        @Config(value={"Should players be able to create their own team? [default: false]"})
        public static boolean createOwnTeam = false;

        public static class Spawns {
            @Config(value={"The range from island center for possible spawns to add. [default: 50]"})
            public static int range = 50;
            @Config(value={"Should players be able to modify their spawn positions? [default: false]"})
            public static boolean modifySpawns = false;
        }

        public static class Teleports {
            @Config(value={"Should players be able to teleport to spawn? [default: true]"})
            public static boolean spawn = true;
            @Config(value={"Cooldown in ticks for teleporting to spawn. [default: 3600 = 3min]"})
            public static int spawnCooldown = 3600;
            @Config(value={"Should players be able to visit other island? [default: true]"})
            public static boolean allowVisits = true;
            @Config(value={"Should players be able to teleport to their home island? [default: true]"})
            public static boolean home = true;
            @Config(value={"Cooldown in ticks for teleporting back home. [default: 3600 = 3min]"})
            public static int homeCooldown = 3600;
            @Config(value={"Should players be able to teleport to another dimension? [default: true]"})
            public static boolean crossDimensionTeleportation = true;
            @Config(value={"Dimensions in this list are not allowed for executing teleportation commands. Inverted behaviour if you set \"allow_list\" to true."})
            public static ResourceList teleportationDimensions = ResourceList.DENY_LIST;
        }
    }

    public static class Inventory {
        @Config(value={"Should all items be reset on first world join? [default: false]", "This will delete all the items given on spawn from other mods guide books."})
        public static boolean clearInv = false;
        @Config(value={"Should players' items be dropped when leaving a team? [default: true]"})
        public static boolean dropItems = true;
    }

    public static class Spawn {
        @Config(value={"The radius of chunks where to apply spawn protection. In this area, only op players can avoid this."})
        public static int spawnProtectionRadius = 0;
        @Config(value={"The radius to find a valid spawn if no given spawn is valid"})
        @IntRange(min=0)
        public static int radius = 50;
        @Config(value={"The dimension the islands will be generated in."})
        public static ResourceKey<Level> dimension = Level.f_46428_;

        public static class Height {
            @Config(value={"set:", "   Uses the bottom height of the range", "range_top:", "   Searches from the top position down to the bottom position for a valid spawn.", "   If no valid position was found, the top position will be used.", "range_bottom:", "   Searches from the top position down to the bottom position for a valid spawn.", "   If no valid position was found, the bottom position will be used."})
            public static SpawnSettings.Type spawnType = SpawnSettings.Type.SET;
            @Config(value={"You can set a range from minY to maxY. minY is the bottom spawn position. maxY is the top spawn dimension.", "If you set the spawn height type to \"set\", the bottom value will be used for a set height. Otherwise, the height will be calculated."})
            public static SpawnSettings.Range range = new SpawnSettings.Range(64, 319);
            @Config(value={"If the spawn height type is set to \"range\", this offset will be used to slightly move the spawn height in any direction.", "Negative values go down, positive values go up."})
            public static int offset = 0;
        }
    }

    public static class World {
        @Config(value={"A list of biomes for each dimension.", "You can not use this for the end dimension. The end dimension will always have it's five biomes.", "Overworld has all oceans by default because animals cannot spawn in these biomes.", "These are resource lists. See https://moddingx.org/libx/org/moddingx/libx/util/data/ResourceList.html#use_resource_lists_in_configs"})
        public static Map<String, ResourceList> biomes = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put(Level.f_46428_.m_135782_().toString(), new ResourceList(false, b -> b.parse("minecraft:*ocean*")));
            map.put(Level.f_46429_.m_135782_().toString(), ResourceList.DENY_LIST);
        });
        @Config(value={"Should a surface be generated in the dimensions? [default: false]"})
        public static boolean surface = false;
        @Config(value={"The block settings for generating the different dimensions surfaces.", "Same format as flat world generation settings (blocks only)"})
        public static Map<String, String> surfaceSettings = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put(Level.f_46428_.m_135782_().toString(), "minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block");
            map.put(Level.f_46429_.m_135782_().toString(), "");
            map.put(Level.f_46430_.m_135782_().toString(), "");
        });
        @Config(value={"Sea level in world [default: 63]"})
        public static int seaHeight = 63;
        @Config(value={"Distance between islands in overworld [default: 8192]", "nether the distance is 1/8"})
        @IntRange(min=64, max=29999900)
        public static int islandDistance = 8192;
        @Config(value={"The offset from 0, 0 to generate the islands", "Can be used to generate them in the middle of .mca files"})
        public static int offset = 0;
    }

    public static class Dimensions {

        public static class End {
            @Config(value={"Should end generate as in default world type? [default: false]"})
            public static boolean Default = false;
            @Config(value={"Should the main island be generated as normal? [default: true]"})
            public static boolean mainIsland = true;
        }

        public static class Nether {
            @Config(value={"Should nether generate as in default world type? [default: false]"})
            public static boolean Default = false;
        }

        public static class Overworld {
            @Config(value={"Should overworld generate as in default world type? [default: false]"})
            public static boolean Default = false;
        }
    }

    @Group(value={"With this you can configure the structures and features which are generated.", "INFO: You can also just use the modid as wildcard for all features/structures from this mod.", "WARNING: Some features like trees need special surface!", "WARNING: This only works for vanilla dimensions (Overworld, Nether, End)"})
    public static class Structures {
        @Config(value={"All the structures that should be generated.", "A list with all possible structures can be found in config/skyblockbuilder/data/structures.txt"})
        public static ResourceList generationStructures = new ResourceList(true, b -> b.simple(new ResourceLocation("minecraft", "fortress")));
        @Config(value={"All the features that should be generated.", "A list with all possible structures can be found in config/skyblockbuilder/data/features.txt", "INFO: The two default values are required for the obsidian towers in end. If this is missing, they will be first generated when respawning the dragon."})
        public static ResourceList generationFeatures = new ResourceList(true, b -> {
            b.simple(new ResourceLocation("minecraft", "end_spike"));
            b.simple(new ResourceLocation("minecraft", "end_gateway"));
        });
    }
}

