/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.mapper;

import com.google.gson.JsonArray;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.noeppi_noeppi.libx.config.ValidatorInfo;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import io.github.noeppi_noeppi.libx.config.gui.WidgetProperties;
import io.github.noeppi_noeppi.libx.impl.config.gui.EditorHelper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.SimpleValueMappers;
import io.github.noeppi_noeppi.libx.screen.Panel;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;

public class BlockPosMapper
implements ValueMapper<BlockPos, JsonArray> {
    public BlockPos fromJson(JsonArray json) {
        if (json.size() != 3) {
            throw new IllegalStateException("Invalid BlockPos: " + json);
        }
        return new BlockPos(json.get(0).getAsInt(), json.get(1).getAsInt(), json.get(2).getAsInt());
    }

    public JsonArray toJson(BlockPos value) {
        JsonArray array = new JsonArray();
        array.add((Number)value.m_123341_());
        array.add((Number)value.m_123342_());
        array.add((Number)value.m_123343_());
        return array;
    }

    public Class<BlockPos> type() {
        return BlockPos.class;
    }

    public Class<JsonArray> element() {
        return JsonArray.class;
    }

    public ConfigEditor<BlockPos> createEditor(ValidatorInfo<?> validator) {
        return new BlockPosEditor();
    }

    private static class BlockPosEditor
    implements ConfigEditor<BlockPos> {
        private BlockPosEditor() {
        }

        public BlockPos defaultValue() {
            return BlockPos.f_121853_;
        }

        public AbstractWidget createWidget(Screen screen, BlockPos initialValue, WidgetProperties<BlockPos> properties) {
            return new BlockPosWidget(screen, initialValue, null, null, null, properties);
        }

        public AbstractWidget updateWidget(Screen screen, AbstractWidget old, WidgetProperties<BlockPos> properties) {
            if (old instanceof BlockPosWidget) {
                return new BlockPosWidget(screen, ((BlockPosWidget)old).getPos(), ((BlockPosWidget)old).xWidget, ((BlockPosWidget)old).yWidget, ((BlockPosWidget)old).zWidget, properties);
            }
            return this.createWidget(screen, this.defaultValue(), properties);
        }

        private static class BlockPosWidget
        extends Panel {
            public final Font font;
            public final AbstractWidget xWidget;
            public final AbstractWidget yWidget;
            public final AbstractWidget zWidget;
            private int posX;
            private int posY;
            private int posZ;

            public BlockPosWidget(Screen screen, BlockPos value, @Nullable AbstractWidget xWidget, @Nullable AbstractWidget yWidget, @Nullable AbstractWidget zWidget, WidgetProperties<BlockPos> properties) {
                super(screen, properties.x(), properties.y(), properties.width(), properties.height());
                this.font = Minecraft.m_91087_().f_91062_;
                this.posX = value.m_123341_();
                this.posY = value.m_123342_();
                this.posZ = value.m_123343_();
                WidgetProperties xProperties = new WidgetProperties(this.font.m_92895_("X") + 3, 0, 50, properties.height(), x -> {
                    this.posX = x;
                    properties.inputChanged().accept(new BlockPos(this.posX, this.posY, this.posZ));
                });
                WidgetProperties yProperties = new WidgetProperties(this.font.m_92895_("XY") + 60, 0, 50, properties.height(), y -> {
                    this.posY = y;
                    properties.inputChanged().accept(new BlockPos(this.posX, this.posY, this.posZ));
                });
                WidgetProperties zProperties = new WidgetProperties(this.font.m_92895_("XYZ") + 120, 0, 50, properties.height(), z -> {
                    this.posZ = z;
                    properties.inputChanged().accept(new BlockPos(this.posX, this.posY, this.posZ));
                });
                ConfigEditor editor = SimpleValueMappers.INTEGER.createEditor(ValidatorInfo.empty());
                this.xWidget = (AbstractWidget)this.addRenderableWidget((GuiEventListener)EditorHelper.create((Screen)screen, (ConfigEditor)editor, (Object)this.posX, (AbstractWidget)xWidget, (WidgetProperties)xProperties));
                this.yWidget = (AbstractWidget)this.addRenderableWidget((GuiEventListener)EditorHelper.create((Screen)screen, (ConfigEditor)editor, (Object)this.posY, (AbstractWidget)yWidget, (WidgetProperties)yProperties));
                this.zWidget = (AbstractWidget)this.addRenderableWidget((GuiEventListener)EditorHelper.create((Screen)screen, (ConfigEditor)editor, (Object)this.posZ, (AbstractWidget)zWidget, (WidgetProperties)zProperties));
            }

            private BlockPos getPos() {
                return new BlockPos(this.posX, this.posY, this.posZ);
            }

            public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
                BlockPosWidget.m_93236_((PoseStack)poseStack, (Font)this.font, (String)"X", (int)this.f_93620_, (int)(this.f_93621_ + 6), (int)Color.GRAY.getRGB());
                BlockPosWidget.m_93236_((PoseStack)poseStack, (Font)this.font, (String)"Y", (int)(this.f_93620_ + 63), (int)(this.f_93621_ + 6), (int)Color.GRAY.getRGB());
                BlockPosWidget.m_93236_((PoseStack)poseStack, (Font)this.font, (String)"Z", (int)(this.f_93620_ + 128), (int)(this.f_93621_ + 6), (int)Color.GRAY.getRGB());
                super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            }
        }
    }
}

