/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.data;

import de.melanx.skyblockbuilder.commands.invitation.InviteCommand;
import de.melanx.skyblockbuilder.compat.minemention.MineMentionCompat;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyblockbuilder.world.IslandPos;
import io.github.noeppi_noeppi.libx.annotation.meta.RemoveIn;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;

public class Team {
    private final SkyblockSavedData data;
    private final Set<UUID> players;
    private final Set<UUID> joinRequests;
    private final Set<BlockPos> possibleSpawns;
    private final Set<BlockPos> defaultPossibleSpawns;
    private UUID teamId;
    private IslandPos island;
    private String name;
    private boolean allowVisits;
    private boolean allowJoinRequests;
    private long createdAt;
    private long lastChanged;
    private WorldUtil.Directions direction;

    private Team(SkyblockSavedData data) {
        this(data, null, null, null);
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.19")
    public Team(SkyblockSavedData data, IslandPos island) {
        this(data, island, UUID.randomUUID(), WorldUtil.Directions.SOUTH);
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.19")
    public Team(SkyblockSavedData data, IslandPos island, UUID teamId) {
        this(data, island, teamId, WorldUtil.Directions.SOUTH);
    }

    public Team(SkyblockSavedData data, IslandPos island, WorldUtil.Directions direction) {
        this(data, island, UUID.randomUUID(), direction);
    }

    public Team(SkyblockSavedData data, IslandPos island, UUID teamId, WorldUtil.Directions direction) {
        this.data = data;
        this.island = island;
        this.players = new HashSet<UUID>();
        this.possibleSpawns = new HashSet<BlockPos>();
        this.defaultPossibleSpawns = new HashSet<BlockPos>();
        this.joinRequests = new HashSet<UUID>();
        this.teamId = teamId;
        this.allowVisits = false;
        this.createdAt = System.currentTimeMillis();
        this.lastChanged = System.currentTimeMillis();
        this.direction = direction;
    }

    public static Team create(SkyblockSavedData data, CompoundTag tag) {
        Team team = new Team(data);
        team.deserializeNBT(tag);
        return team;
    }

    public boolean isSpawn() {
        return Objects.equals(this.teamId, SkyblockSavedData.SPAWN_ID);
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.teamId;
    }

    public void setName(String name) {
        this.name = name;
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
    }

    public IslandPos getIsland() {
        return this.island;
    }

    public void setIsland(IslandPos island) {
        this.island = island;
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public void setPlayers(Collection<UUID> players) {
        this.players.clear();
        PlayerList playerList = this.getLevel().m_142572_().m_6846_();
        if (ModList.get().isLoaded("minemention")) {
            for (UUID id : players) {
                MineMentionCompat.updateMentions(playerList.m_11259_(id));
            }
        }
        this.players.addAll(players);
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
    }

    public Set<BlockPos> getPossibleSpawns() {
        return this.possibleSpawns;
    }

    public Set<BlockPos> getDefaultPossibleSpawns() {
        return this.defaultPossibleSpawns;
    }

    public void setPossibleSpawns(Collection<BlockPos> spawns) {
        this.possibleSpawns.clear();
        this.defaultPossibleSpawns.clear();
        this.possibleSpawns.addAll(spawns);
        this.defaultPossibleSpawns.addAll(spawns);
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
    }

    public void addPossibleSpawn(BlockPos pos) {
        this.possibleSpawns.add(pos);
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
    }

    public boolean removePossibleSpawn(BlockPos pos) {
        if (this.possibleSpawns.size() <= 1) {
            return false;
        }
        boolean remove = this.possibleSpawns.remove(pos);
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
        return remove;
    }

    public boolean allowsVisits() {
        return this.allowVisits;
    }

    public boolean toggleAllowVisits() {
        this.allowVisits = !this.allowVisits;
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
        return this.allowVisits;
    }

    public void setAllowVisit(boolean enabled) {
        if (this.allowVisits != enabled) {
            this.allowVisits = enabled;
            this.lastChanged = System.currentTimeMillis();
            this.data.m_77762_();
        }
    }

    public boolean addPlayer(UUID player) {
        boolean added = this.players.add(player);
        if (added) {
            if (ModList.get().isLoaded("minemention")) {
                MineMentionCompat.updateMentions(this.getLevel().m_142572_().m_6846_().m_11259_(player));
            }
            if (!this.isSpawn()) {
                this.data.getSpawn().removePlayer(player);
            }
            this.lastChanged = System.currentTimeMillis();
            this.data.getOrCreateMetaInfo(player).setTeamId(this.teamId);
            this.data.m_77762_();
        }
        return added;
    }

    public boolean addPlayer(Player player) {
        return this.addPlayer(player.m_36316_().getId());
    }

    public boolean addPlayers(Collection<UUID> players) {
        boolean added = this.players.addAll(players);
        if (added) {
            if (ModList.get().isLoaded("minemention")) {
                for (UUID id : players) {
                    MineMentionCompat.updateMentions(this.getLevel().m_142572_().m_6846_().m_11259_(id));
                    this.data.getOrCreateMetaInfo(id).setTeamId(this.teamId);
                }
            }
            this.lastChanged = System.currentTimeMillis();
            this.data.m_77762_();
        }
        return added;
    }

    public boolean removePlayer(Player player) {
        return this.removePlayer(player.m_36316_().getId());
    }

    public boolean removePlayer(UUID player) {
        boolean removed = this.players.remove(player);
        if (ModList.get().isLoaded("minemention")) {
            MineMentionCompat.updateMentions(this.getLevel().m_142572_().m_6846_().m_11259_(player));
        }
        if (removed) {
            this.data.getOrCreateMetaInfo(player).addPreviousTeamId(this.teamId);
            this.lastChanged = System.currentTimeMillis();
        }
        this.data.m_77762_();
        return removed;
    }

    public void removePlayers(Collection<UUID> players) {
        for (UUID id : players) {
            boolean removed = this.players.remove(id);
            if (ModList.get().isLoaded("minemention")) {
                MineMentionCompat.updateMentions(this.getLevel().m_142572_().m_6846_().m_11259_(id));
            }
            if (!removed) continue;
            this.data.getOrCreateMetaInfo(id).addPreviousTeamId(this.teamId);
        }
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
    }

    public void removeAllPlayers() {
        this.removePlayers(this.players);
    }

    public boolean hasPlayer(UUID player) {
        return this.players.contains(player);
    }

    public boolean hasPlayer(Player player) {
        return this.hasPlayer(player.m_36316_().getId());
    }

    public boolean isEmpty() {
        return this.players.isEmpty();
    }

    public boolean allowsJoinRequests() {
        return this.allowJoinRequests;
    }

    public boolean toggleAllowJoinRequest() {
        this.allowJoinRequests = !this.allowJoinRequests;
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
        return this.allowJoinRequests;
    }

    public void setAllowJoinRequest(boolean enabled) {
        if (this.allowJoinRequests != enabled) {
            this.allowJoinRequests = enabled;
            this.lastChanged = System.currentTimeMillis();
            this.data.m_77762_();
        }
    }

    public Set<UUID> getJoinRequests() {
        return this.joinRequests;
    }

    public void addJoinRequest(Player player) {
        this.addJoinRequest(player.m_36316_().getId());
    }

    public void addJoinRequest(UUID id) {
        this.joinRequests.add(id);
        this.data.m_77762_();
    }

    public void removeJoinRequest(Player player) {
        this.removeJoinRequest(player.m_36316_().getId());
    }

    public void removeJoinRequest(UUID id) {
        this.joinRequests.remove(id);
        this.data.m_77762_();
    }

    public void resetJoinRequests() {
        this.joinRequests.clear();
        this.data.m_77762_();
    }

    public void sendJoinRequest(Player requestingPlayer) {
        this.addJoinRequest(requestingPlayer.m_36316_().getId());
        TranslatableComponent component = new TranslatableComponent("skyblockbuilder.event.join_request0", new Object[]{requestingPlayer.m_5446_()});
        component.m_7220_((Component)new TextComponent("/skyblock team accept " + requestingPlayer.m_5446_().getString()).m_6270_(Style.f_131099_.m_131144_(InviteCommand.COPY_TEXT).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/skyblock team accept " + requestingPlayer.m_5446_().getString())).m_131152_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})));
        component.m_7220_((Component)new TranslatableComponent("skyblockbuilder.event.join_request1"));
        this.broadcast((MutableComponent)component, Style.f_131099_.m_131157_(ChatFormatting.GOLD));
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getLastChanged() {
        return this.lastChanged;
    }

    public void updateLastChanged() {
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
    }

    public void setDirection(WorldUtil.Directions direction) {
        this.direction = direction;
    }

    public WorldUtil.Directions getDirection() {
        return this.direction;
    }

    @Nullable
    public ServerLevel getLevel() {
        return this.data.getLevel();
    }

    public void broadcast(MutableComponent msg, Style style) {
        if (this.getLevel() == null || this.getLevel().f_46443_) {
            return;
        }
        PlayerList playerList = this.getLevel().m_142572_().m_6846_();
        this.players.forEach(uuid -> {
            ServerPlayer player = playerList.m_11259_(uuid);
            if (player != null) {
                MutableComponent component = new TextComponent("[" + this.name + "] ").m_6270_(Style.f_131099_);
                player.m_6352_((Component)component.m_7220_((Component)msg.m_130948_(style)), uuid);
            }
        });
    }

    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("TeamId", this.teamId);
        nbt.m_128365_("Island", (Tag)this.island.toTag());
        nbt.m_128359_("Name", this.name != null ? this.name : "");
        nbt.m_128379_("Visits", this.allowVisits);
        nbt.m_128379_("AllowJoinRequests", this.allowJoinRequests);
        nbt.m_128356_("CreatedAt", this.createdAt);
        nbt.m_128356_("LastChanged", this.lastChanged);
        nbt.m_128359_("SpawnPointDirection", this.direction.name());
        ListTag players = new ListTag();
        for (UUID uUID : this.players) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("Player", uUID);
            players.add((Object)compoundTag);
        }
        ListTag spawns = new ListTag();
        for (BlockPos blockPos : this.possibleSpawns) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128347_("posX", (double)blockPos.m_123341_() + 0.5);
            posTag.m_128347_("posY", (double)blockPos.m_123342_());
            posTag.m_128347_("posZ", (double)blockPos.m_123343_() + 0.5);
            spawns.add((Object)posTag);
        }
        ListTag listTag = new ListTag();
        for (BlockPos pos : this.defaultPossibleSpawns) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128347_("posX", (double)pos.m_123341_() + 0.5);
            posTag.m_128347_("posY", (double)pos.m_123342_());
            posTag.m_128347_("posZ", (double)pos.m_123343_() + 0.5);
            listTag.add((Object)posTag);
        }
        ListTag listTag2 = new ListTag();
        for (UUID id : this.joinRequests) {
            CompoundTag idTag = new CompoundTag();
            idTag.m_128362_("Id", id);
            listTag2.add((Object)idTag);
        }
        nbt.m_128365_("Players", (Tag)players);
        nbt.m_128365_("Spawns", (Tag)spawns);
        nbt.m_128365_("DefaultSpawns", (Tag)listTag);
        nbt.m_128365_("JoinRequests", (Tag)listTag2);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.teamId = nbt.m_128342_("TeamId");
        this.island = IslandPos.fromTag(nbt.m_128469_("Island"));
        this.name = nbt.m_128461_("Name");
        this.allowVisits = nbt.m_128471_("Visits");
        this.allowJoinRequests = nbt.m_128471_("AllowJoinRequests");
        this.createdAt = nbt.m_128454_("CreatedAt");
        this.lastChanged = nbt.m_128454_("LastChanged");
        this.direction = WorldUtil.Directions.valueOf(nbt.m_128461_("SpawnPointDirection"));
        ListTag players = nbt.m_128437_("Players", 10);
        this.players.clear();
        for (Object player : players) {
            this.players.add(((CompoundTag)player).m_128342_("Player"));
        }
        ListTag spawns = nbt.m_128437_("Spawns", 10);
        this.possibleSpawns.clear();
        for (Object pos : spawns) {
            CompoundTag posTag = (CompoundTag)pos;
            this.possibleSpawns.add(new BlockPos(posTag.m_128459_("posX"), posTag.m_128459_("posY"), posTag.m_128459_("posZ")));
        }
        ListTag defaultSpawns = nbt.m_128437_("DefaultSpawns", 10);
        if (defaultSpawns.isEmpty()) {
            defaultSpawns.addAll((Collection)spawns);
        }
        this.defaultPossibleSpawns.clear();
        for (Tag pos : defaultSpawns) {
            CompoundTag posTag = (CompoundTag)pos;
            this.defaultPossibleSpawns.add(new BlockPos(posTag.m_128459_("posX"), posTag.m_128459_("posY"), posTag.m_128459_("posZ")));
        }
        ListTag joinRequests = nbt.m_128437_("JoinRequests", 10);
        this.joinRequests.clear();
        for (Tag id : joinRequests) {
            this.joinRequests.add(((CompoundTag)id).m_128342_("Id"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Team)) {
            return false;
        }
        Team team = (Team)o;
        return this.name.equals(team.name) && this.island.equals(team.island);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result * this.island.hashCode();
        return result;
    }
}

