/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.item;

import com.google.common.collect.Sets;
import de.melanx.skyblockbuilder.util.ClientUtility;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ItemStructureSaver
extends Item {
    private static final MutableComponent TOOLTIP_INFO = new TranslatableComponent("skyblockbuilder.item.structure_saver.info.tooltip").m_130940_(ChatFormatting.GOLD);
    private static final MutableComponent TOOLTIP_SAVE = new TranslatableComponent("skyblockbuilder.item.structure_saver.save.tooltip").m_130940_(ChatFormatting.GOLD);

    public ItemStructureSaver() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40756_));
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (!context.m_43725_().f_46443_ && player != null && player.m_6144_()) {
            ItemStack stack = context.m_43722_();
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("Position1")) {
                tag.m_128365_("Position1", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                player.m_5661_((Component)new TranslatableComponent("skyblockbuilder.structure_saver.pos", new Object[]{1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
                return InteractionResult.SUCCESS;
            }
            if (!tag.m_128441_("Position2")) {
                tag.m_128365_("Position2", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                player.m_5661_((Component)new TranslatableComponent("skyblockbuilder.structure_saver.pos", new Object[]{2, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Position1") && tag.m_128441_("Position2")) {
            if (!tag.m_128441_("CanSave")) {
                tag.m_128379_("CanSave", true);
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (level.f_46443_) {
                ClientUtility.openItemScreen(stack);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        BlockPos pos;
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("Position1")) {
            pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position1"));
            tooltip.add((Component)new TranslatableComponent("skyblockbuilder.item.structure_saver.position.tooltip", new Object[]{1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (nbt.m_128441_("Position2")) {
            pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position1"));
            tooltip.add((Component)new TranslatableComponent("skyblockbuilder.item.structure_saver.position.tooltip", new Object[]{1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (nbt.m_128441_("CanSave")) {
            tooltip.add((Component)TOOLTIP_SAVE);
        } else {
            tooltip.add((Component)TOOLTIP_INFO);
        }
    }

    @Nullable
    public static BoundingBox getArea(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("Position1") || !nbt.m_128441_("Position2")) {
            return null;
        }
        BlockPos pos1 = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position1"));
        BlockPos pos2 = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position2"));
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static String saveSchematic(Level level, ItemStack stack, boolean ignoreAir) {
        return ItemStructureSaver.saveSchematic(level, stack, ignoreAir, null);
    }

    public static String saveSchematic(Level level, ItemStack stack, boolean ignoreAir, @Nullable String name) {
        StructureTemplate template = new StructureTemplate();
        BoundingBox boundingBox = ItemStructureSaver.getArea(stack);
        if (boundingBox == null) {
            return null;
        }
        BlockPos origin = new BlockPos(boundingBox.m_162395_(), boundingBox.m_162396_(), boundingBox.m_162398_());
        BlockPos bounds = new BlockPos(boundingBox.m_71056_(), boundingBox.m_71057_(), boundingBox.m_71058_());
        HashSet toIgnore = Sets.newHashSet((Object[])new Block[]{Blocks.f_50454_});
        if (ignoreAir) {
            toIgnore.add(Blocks.f_50016_);
        }
        RandomUtility.fillTemplateFromWorld(template, level, origin, (Vec3i)bounds, true, toIgnore);
        Path path = Paths.get(RandomUtility.getFilePath(SkyPaths.MOD_EXPORTS.getFileName().toString(), name), new String[0]);
        try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);){
            CompoundTag tag = template.m_74618_(new CompoundTag());
            NbtIo.m_128947_((CompoundTag)tag, (OutputStream)outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return path.getFileName().toString();
    }

    public static ItemStack removeTags(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("Position1");
        tag.m_128473_("Position2");
        tag.m_128473_("CanSave");
        stack.m_41751_(tag);
        return stack;
    }
}

