/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.client.GameProfileCache;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ProfilesUpdateHandler {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            HashSet<GameProfile> profiles = new HashSet<GameProfile>();
            for (Tag tag : msg.profiles.m_128437_("Profiles", 10)) {
                CompoundTag nbt = (CompoundTag)tag;
                UUID id = nbt.m_128342_("Id");
                String name = nbt.m_128461_("Name");
                profiles.add(new GameProfile(id, name));
            }
            GameProfileCache.addProfiles(profiles);
        });
        ctx.get().setPacketHandled(true);
    }

    public record Message(CompoundTag profiles) {
    }

    public static class ProfilesUpdateSerializer
    implements PacketSerializer<Message> {
        public Class<Message> messageClass() {
            return Message.class;
        }

        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130079_(msg.profiles);
        }

        public Message decode(FriendlyByteBuf buffer) {
            return new Message(buffer.m_130260_());
        }
    }
}

